#include "startview.h"
#include <QHBoxLayout>
#include <QPushButton>
#include <QMenu>
#include <QMenuBar>
#include <applicationmenu.h>
#include <editview.h>
#include <QDebug>
#ifdef Q_WS_MAEMO_5
    #include <QtMaemo5>
#endif

StartView::StartView()
{
    //layout
    QHBoxLayout *layout = new QHBoxLayout(this);

    //buttons
    QPushButton *track = new QPushButton("Capture");
    QPushButton *view = new QPushButton("History");
    track->setIcon(QIcon(":/images/camera.png"));
    view->setIcon(QIcon(":/images/chart.png"));
    track->setIconSize(QSize(150,150));
    view->setIconSize(QSize(150,150));
    track->setFlat(true);
    view->setFlat(true);
    track->setStyleSheet("QPushButton:flat:pressed {background-color: #8f8f91;}");
    view->setStyleSheet("QPushButton:flat:pressed {background-color: #8f8f91;}");
    layout->addWidget(track);
    layout->addWidget(view);

    //add menu to layout
    ApplicationMenu *startMenu = new ApplicationMenu(this);
    layout->setMenuBar(startMenu);

    this->setLayout(layout);

    //connect buttons and view signals to slots
    connect(view,SIGNAL(clicked()), this, SLOT(historyButtonClicked()));
    connect(track, SIGNAL(clicked()),this, SLOT(trackButtonClicked()));


}

void StartView::historyButtonClicked()
{
    //new pointer to history
    history = new HistoryView(this);
    //if built in maemo, set windows stacked
#ifdef Q_WS_MAEMO_5
    history->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    history->setWindowFlags(history->windowFlags() | Qt::Window);
    history->show();
}

void StartView::trackButtonClicked()
{
    //new pointer to tracking
    cameraViewFinder = new CameraViewFinder(this);
    //if built in maemo, set windows stacked
#ifdef Q_WS_MAEMO_5
    cameraViewFinder->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    cameraViewFinder->setWindowFlags(cameraViewFinder->windowFlags() | Qt::Window);
    cameraViewFinder->setAttribute(Qt::WA_DeleteOnClose, true);
    cameraViewFinder->show();

    connect(cameraViewFinder, SIGNAL(valuesFound()), this, SLOT(openEditView()));
}

void StartView::openEditView()
{
    //new pointer to edit view
    edit = new EditView(this);
    //if built in maemo, set windows stacked
#ifdef Q_WS_MAEMO_5
    edit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    edit->setWindowFlags(edit->windowFlags() | Qt::Window);
    edit->show();

    connect(edit, SIGNAL(trackAgain()), this, SLOT(trackButtonClicked()));

}
