#include "measurement.h"
#include <QDebug>
#include <QDesktopServices>
#include <QTextStream>
#define HISTORYFILE "history.csv"
#define DATAFILE "data.dat"

Measurement::Measurement()
{
    //create csv file
    CSVFile = new QFile(QDesktopServices::storageLocation(QDesktopServices::TempLocation) + "/" + HISTORYFILE);
    //create data cache file
    DataFile = new QFile(QDesktopServices::storageLocation(QDesktopServices::TempLocation) + "/" + DATAFILE);
}

Measurement *Measurement::instance()
{
    if(m_instance == 0)
        m_instance = new Measurement();

    return (m_instance);
}

void Measurement::clearHistory()
{
    CSVFile->remove();
    DataFile->remove();
    date.clear();
    time.clear();
    sys = 0;
    dia = 0;
    pulse = 0;
    weight = 0;
    values.clear();
    allValues.clear();
}

void Measurement::saveData(QList<QString> measuredValues)
{
    //save data to variables
    date = measuredValues.takeFirst();
    time = measuredValues.takeFirst();
    sys = measuredValues.takeFirst().toInt();
    dia = measuredValues.takeFirst().toInt();
    pulse = measuredValues.takeFirst().toInt();
    weight = measuredValues.takeFirst().toInt();
    //map the gathered data
    values.insert("date", date);
    values.insert("time", time);
    values.insert("sys", QString::number(sys));
    values.insert("dia",QString::number(dia));
    values.insert("pulse", QString::number(pulse));
    values.insert("weight", QString::number(weight));
    //put all saved values in a list
    allValues.append(values);

    //Save data in CSV file to be opened in Exel
    if (!CSVFile->open(QIODevice::WriteOnly | QIODevice::Text))
    {
        qDebug()<<"cannot open file for writing";

    }
    else
    {   //Save the data in a .csv file
        QTextStream out(CSVFile);
        out << "Date, Time, SYS, DIA, Pulse, Weight\n";
        QMap<QString, QString> saveMap;
        foreach (saveMap, allValues)
        {
            out << saveMap.value("date");
            out << ",";
            out << saveMap.value("time");
            out << ",";
            out << saveMap.value("sys");
            out << ",";
            out << saveMap.value("dia");
            out << ",";
            out << saveMap.value("pulse");
            out << ",";
            out << saveMap.value("weight");
            out << "\n";
        }
        CSVFile->close();
    }

    //Save the data to .dat to be reopened
    if (!DataFile->open(QIODevice::WriteOnly))
        qDebug()<<"cannot open file for writing";
    else
    {
        //write the points in a dat file for reopening
        //data to lists
        QDataStream stream( DataFile );
        stream.setVersion( QDataStream::Qt_4_6);

        stream << allValues;
        DataFile->close();
    }
}

QList<QMap<QString, QString> > Measurement::getValues()
{

    if( !DataFile->open( QIODevice::ReadOnly ) )
        qDebug()<<"cannot open file for reading";
    else
    {
        //get all values from datafile
        QDataStream stream( DataFile );
        stream.setVersion( QDataStream::Qt_4_6 );
        stream >> allValues;
        DataFile->close();
    }
    return allValues;
}
