#ifndef LINECHARTVIEW_H
#define LINECHARTVIEW_H

#include <QWidget>
#include <QGridLayout>
#include <QGraphicsView>
#include <QCheckBox>
#include <linechartbuilder.h>

//! LineChartView class.
/*!
  This class displays the line chart
  created from user's measurement data
*/
class LineChartView : public QWidget
{
    Q_OBJECT
public:
    //! Constructor
    /*! \param parent Widget to return to */
    explicit LineChartView(QWidget *parent = 0);

private:
    //! Pointer to LineChartBuilder class
    LineChartBuilder *chart;
    //! Main layout for the view
    QHBoxLayout *mainLayout;
    //! Graphics view to show the line graph in
    QGraphicsView *view;
    QCheckBox *red;
    QCheckBox *yellow;
    QCheckBox *blue;
    QCheckBox *green;
    QVBoxLayout *buttonsLayout;
    QHBoxLayout *checkBoxTitles;
    QVBoxLayout *leftSide;
    QHBoxLayout *chartLayout;

signals:

public slots:
    //! This method rebuilds the line graph based on selections
    void handleCheckBoxToggle();

};

#endif // LINECHARTVIEW_H
