#ifndef HISTORYVIEW_H
#define HISTORYVIEW_H

#include <QWidget>
#include <QTableWidget>
#include <measurement.h>

//! HistoryView class.
/*!
  This class creates the view for
  tables and charts
*/
class HistoryView : public QWidget
{
    Q_OBJECT
public:
    //! A constructor.
    /*! \param parent widget to return to.*/
    explicit HistoryView(QWidget *parent = 0);
    //! List to store colledted values for passing on.
    QList<QMap<QString, QString> > values;
private:
    //! Pointer to measurement class
    Measurement *measurement;
    //! Table
    QTableWidget *tableWidget;

private slots:
    void handleLineGraphButton();

};

#endif // HISTORYVIEW_H
