#ifndef CAMERAOVERLAY_H
#define CAMERAOVERLAY_H

#include <QWidget>
#include <QEvent>
#include <QPainter>

#define __user
#include "./include/omapfb.h"

#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <FCam/Image.h>

//! CameraOverlay class.
/*!
    This class manages an fbdev YUV overlay, suitable for drawing viewfinder frames on.
*/

class CameraOverlay : public QWidget {
  public:
    //! CameraOverlay constructor
    CameraOverlay(QWidget *parent = NULL);
    //! CameraOverlay destructor
    ~CameraOverlay();

    //! If you draw on a widget at the same place as this one, using
    //! any color but the one below, it will show through the overlay.
    static QColor colorKey() {return QColor(10, 0, 10);}

    //! A reference to the frame buffer
    FCam::Image framebuffer();
    
 protected:
    virtual void paintEvent(QPaintEvent * event);
    struct omapfb_color_key old_color_key;
    
    void resizeEvent(QResizeEvent *);
    void moveEvent(QMoveEvent *);
    void showEvent(QShowEvent *);
    void hideEvent(QHideEvent *);
    bool eventFilter(QObject *receiver, QEvent *event);

    void enable();    
    void disable();

    FCam::Image framebuffer_;

    struct fb_var_screeninfo overlay_info;
    struct omapfb_mem_info mem_info;
    struct omapfb_plane_info plane_info;
    int overlay_fd;

    bool filterInstalled;
private:
    //! Line center point
    QPointF lineCenterPoint;
    //! Lenght of the lines
    int lineLength;
};

#endif // CAMERAOVERLAY_H
