#ifndef APPLICATIONMENU_H
#define APPLICATIONMENU_H
#include <modeldialog.h>
#include <QMenuBar>
#include <QWidget>
#include <QMessageBox>
#include <smtp.h>

//! ApplicationMenu class.
/*!
  This class contains creates the application
  menu for each view
*/
class ApplicationMenu : public QMenuBar
{
    Q_OBJECT
public:
    //! A constructor.
    /*! \param parent widget to return to */
    ApplicationMenu(QWidget *parent, int view = 0);

    //! Pointer to ModelDialog class
    ModelDialog *modelDialog;

private:
    ApplicationMenu();
    Smtp *smtp;
    QMessageBox *message;

private slots:
    void emptyHistory();
    void sendMail();
};

#endif // APPLICATIONMENU_H
