# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *

class Score(QGraphicsObject):
    score = 2
    color = Qt.black

    def __init__(self, parent = None, player = False):
        QGraphicsObject.__init__(self, parent)
        if player: self.color = Qt.white
        self.player = player

    def paint(self, painter, option, widget):
        painter.setPen(Qt.black)
        #painter.drawRoundedRect(0, 0, 30, 50, 0, 0)
        painter.setBrush(self.color)
        painter.drawEllipse(0, 0, 30, 30)
        painter.drawText(10, 55, str(self.score))

    def boundingRect(self):
        return QRectF(0, 0, 30, 60)

    def setScore(self, player = False, score = 2):
        if self.player == player:
            self.score = score
            self.update()

    def reset(self):
        self.score = 2
        self.update()
