/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef PPXMLPAPER_H
#define PPXMLPAPER_H

#include <QDomDocument>
#include "ppgraphicsstroke.h"
#include "ppbackground.h"
#include "pppaper.h"

/// XML representation of handwriting data

class PPXmlPaper
{
public:
    PPXmlPaper();

    /// Read from paper, generate a new XML representation
    virtual QDomElement read(PPPaper *paper);

    /// Read from element
    void read(QDomElement elem);

    /// Write the XML representation to a paper instance
    bool write(PPPaper *paper);

    /// Write the XML represent to be the child of a QDomNode
    bool write(QDomNode node);

    void setDocument(QDomDocument &val);
    QDomDocument document();

    QDomElement createStrokeElement(PPGraphicsStroke *stroke , QDomDocument &doc );
    bool setStrokeFromElement(PPGraphicsStroke *stroke, QDomElement &element);

private:
    QDomDocument m_document;

};

#endif // PPXMLPAPER_H
