#ifndef PPPEN_H
#define PPPEN_H

#include <QGraphicsObject>
#include "ppgraphicsstroke.h"

/// Pen drawing tool on QGraphicsItem

class PPPen : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit PPPen(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;

    /// Start to draw on graphics item
    void start(QGraphicsItem* canvas);

    /// Stop the capture. It won't emit captured signal
    void stop();

    /// Set the pen style directly. It will override the color and line width
    void setPen(QPen &pen);
    QPen pen();

    QColor color();
    void setColor(QColor color);

    void setWidth(int val);
    int width();

signals:
    /// The signal is emitted when a stroke is added.
    void added();

public slots:

protected:
    virtual bool sceneEventFilter ( QGraphicsItem * watched, QEvent * event);

private:
    QGraphicsItem *canvas;
    QPen m_pen;

    PPGraphicsStroke *stroke;
};

#endif // PPPEN_H
