/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef PPPAPER_H
#define PPPAPER_H

#include <QGraphicsObject>
#include "ppbackground.h"
#include "ppgraphicsstroke.h"

/// A QGraphicsItem for handwriting

class PPPaper : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit PPPaper(QGraphicsItem *parent = 0);

    virtual QRectF boundingRect() const;
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    /// Get the drawing area of the paper on scene
    QRect rect() const;

    /// Set the drawing area of the paper on scene
    void setRect(QRect val);

    bool dirty();

    /// Set the background of paper
    void setBackground(PPBackground val);

    PPBackground background();

    /// The next ID to be assigned for stroke
    int nextId();

signals:

public slots:
    void setDirty(bool val = true);

    /// clear the content and reset to initial status
    virtual void clear();

protected:
    QVariant itemChange(GraphicsItemChange change, const QVariant & value);

private:
    QRect m_rect;
    bool m_dirty;
    int m_nextId;

    PPBackground m_background;
};

#endif // PPPAPER_H
