#ifndef PPGRAPHICSSTROKE_H
#define PPGRAPHICSSTROKE_H

#include <QGraphicsObject>
#include <QPolygon>
#include <QPen>

/// Stroke graphical item

class PPGraphicsStroke : public QGraphicsItem
{
public:
    explicit PPGraphicsStroke(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;
    virtual QPainterPath shape () const;

    // XmlIOIface interfaces
    /*
    virtual QString tagName();
    virtual QDomElement createDomElement(QDomDocument &doc);
    virtual bool setFromDomElement(QDomElement &elem);
    */
    /// Set the ID of the stroke.
    /**
      Usually you don't set by yourself. Whatever a stroke
      with ID equal to zero added to a PPPaper. It's ID
      will be assigned automatically. The ID should be
      unique within the paper

      @param val The ID of the stroke. The value should be greater than 0.
      @remarks The ID is also eqaul to the zorder of the object.
     */
    void setId(int val);
    int id();

    QPolygonF polygon();
    void setPolygon(QPolygonF val);

    /// Simplifed polygon with duplicated points removed
    QVector<QPointF> points();

    void append(const QPointF pt,bool refresh = true);

    void clear();

    void setPen(const QPen& val);
    QPen pen();

private:
    void updateBoundingRect();

    QPen m_pen;
    QPolygonF m_polygon;

    QRectF m_boundingRect;

    int m_id;
};

QDebug operator<<(QDebug dbg, PPGraphicsStroke &stroke);

#endif // FVGRAPHICSSTROKE_H
