#ifndef PPPAPERBACKGROUND_H
#define PPPAPERBACKGROUND_H

#include <QSharedDataPointer>
#include <QColor>
#include <QPixmap>
#include <QUrl>

class PPBackgroundPriv;

/// Background information data structure and helper class
/**
  @remarks It is an implicit sharing class
 */
class PPBackground
{
public:
    PPBackground();
    PPBackground(const PPBackground &);
    PPBackground &operator=(const PPBackground &);
    ~PPBackground();

    /// Return TRUE if it is never be set
    bool isNull();

    /// Set the background as a single pure color
    void setColor(QColor val);
    QColor color();

    /// Set a pixmap as the background
    void setPixmap(QPixmap val);
    QPixmap pixmap();

    void setRepeatX(bool val);
    bool repeatX();

    void setRepeatY(bool val);
    bool repeatY();

    /// Set the src of the background
    void setSrc(QUrl url);
    QUrl src();

    /// Load pixmap from the src assigned
    bool load();

    /// Create a QBrush based on the information assigned.
    QBrush brush();

    /// Paint background
    void paint(QPainter *painter , QRect rect , QPoint origin = QPoint(0,0));

private:
    QSharedDataPointer<PPBackgroundPriv> d;
};

#endif // PPPAPERBACKGROUND_H
