#include "ppbackground.h"
#include <QSharedData>
#include <QVariant>
#include <QBrush>
#include <QtCore>
#include <QPainter>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
class PPBackgroundPriv : public QSharedData {
public:
    PPBackgroundPriv() {
        null = true;
        repeatX = repeatY = false;
    }
    PPBackgroundPriv(const PPBackgroundPriv &other)
        : QSharedData(other)
         {
        null = other.null;
        color = other.color;
        pixmap = other.pixmap;
        repeatX = other.repeatX;
        repeatY = other.repeatY;
        src = other.src;
    }
    ~PPBackgroundPriv() { }

    QColor color;
    QPixmap pixmap;
    bool repeatX;
    bool repeatY;
    QUrl src;
    bool null;
};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

PPBackground::PPBackground() : d(new PPBackgroundPriv)
{
}

PPBackground::PPBackground(const PPBackground &rhs) : d(rhs.d)
{
}

PPBackground &PPBackground::operator=(const PPBackground &rhs)
{
    if (this != &rhs)
        d.operator=(rhs.d);
    return *this;
}

PPBackground::~PPBackground()
{
}

bool PPBackground::isNull(){
    return d->null;
}

void PPBackground::setColor(QColor val){
    d->null = false;
    d->color = val;
}

QColor PPBackground::color(){
    return d->color;
}

void PPBackground::setPixmap(QPixmap val){
    d->null = false;
    d->pixmap = val;
}

QPixmap PPBackground::pixmap(){
    return d->pixmap;
}

void PPBackground::setRepeatX(bool val){
    d->null = false;
    d->repeatX = val;
}

bool PPBackground::repeatX(){
    return d->repeatX;
}

void PPBackground::setRepeatY(bool val){
    d->null = false;
    d->repeatY = val;
}

bool PPBackground::repeatY(){
    return d->repeatY;
}

void PPBackground::setSrc(QUrl url){
    d->null = false;

    d->src = url;
}

QUrl PPBackground::src(){
    return d->src;
}

bool PPBackground::load(){
    bool res = false;
    if (!d->src.isEmpty()) {
        QPixmap p;

        res = p.load(d->src.toLocalFile());
        if (res) {
            d->pixmap = p;
        }
    }
    return res;
}

QBrush PPBackground::brush() {
    QBrush brush(d->color);

    if (!d->pixmap.isNull()){
        brush.setTexture(d->pixmap);
    }

    return brush;
}

void PPBackground::paint(QPainter *painter , QRect rect , QPoint origin){
    painter->save();

    QPen pen(Qt::NoPen);
    painter->setPen(pen);

    QBrush b(d->color);
    painter->setBrush(b);
    painter->drawRect(rect);

    QRect target = rect;

    if (!d->pixmap.isNull()) {
        b.setTexture(d->pixmap);
        /*
        QPoint disp = rect.topLeft() - origin;
        QTransform transform;
        transform.translate(disp.x(),disp.y());
        b.setTransform(transform);
        painter->setBrushOrigin(disp);
        */

        // No need to modify target rect if both of repeatX & repeatY is set
        if ( !(d->repeatX && d->repeatY) ) {
            QRect source = d->pixmap.rect();

            if (d->repeatX) {
                source.setX(-2147483647 / 2);
                source.setWidth(2147483647); // Infine width rectangle
            } else if (d->repeatY) {
                source.setY(-2147483647 / 2);
                source.setHeight(2147483647); // Infine height rectangle
            }

            target = rect.intersected(source);
        }

        painter->setBrush(b);
        painter->drawRect(target);
    }

    painter->restore();
}
