/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef PPBACKGROUNDMODEL_H
#define PPBACKGROUNDMODEL_H

#include <QList>
#include <QAbstractItemModel>

#include "ppbackground.h"

class PPBackgroundModelPriv {
public:
    /*
    inline PPBackgroundModelPriv(){
    }

    inline PPBackgroundModelPriv(const PPBackgroundModelPriv &other) {
        name = other.name;
        bg = other.bg;
    }
    */

    QString name;
    PPBackground bg;
};

/// Background information model

class PPBackgroundModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    explicit PPBackgroundModel(QObject *parent = 0);

    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;

    virtual QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    virtual QModelIndex parent ( const QModelIndex & index ) const;

    virtual Qt::ItemFlags flags ( const QModelIndex & index ) const;

    void append(PPBackground bg , QString name = QString() );

    /// Append a background to model, and try to load its pixmap from file
    void append(PPBackground bg, QString name , QString file);

    void addSearchingPath(QString path);

    /// Set the size of thumbnail image
    void setThumbnailSize(QSize size);

    /// Get the background at index
    PPBackground backgroundAt(int index);

signals:

public slots:

private:
    QList<PPBackgroundModelPriv> storage;

    /// The searching path for loadPixmap()
    QList<QString> m_searchingPath;

    QSize m_thumbnailSize;
    QSize m_paperSize;
};

#endif // PPBACKGROUNDMODEL_H
