/**
  @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>

#include "maemo5colordialog.h"
#include "ui_maemo5colordialog.h"

Maemo5ColorDialog::Maemo5ColorDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Maemo5ColorDialog)
{
    ui->setupUi(this);

    connect(ui->hPicker,SIGNAL(hueChanged(int)),
            ui->svPicker,SLOT(setHue(int)));
    connect(ui->hPicker,SIGNAL(hueChanged(int)),
            this,SLOT(updateColor()));

    connect(ui->svPicker,SIGNAL(changed(int,int)),
            this,SLOT(updateColor()));

    ui->svPicker->setHue(ui->hPicker->hue());

    updateColor();
}

Maemo5ColorDialog::~Maemo5ColorDialog()
{
    delete ui;
}

void Maemo5ColorDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Maemo5ColorDialog::setCurrentColor(QColor val){
//    val = val.toHsv();
    qDebug() << val.hue() << val.saturation() << val.value();
    ui->hPicker->setHue(val.hue());
    ui->svPicker->setSaturation(val.saturation());
    ui->svPicker->setValue(val.value());
    // It will trigger updateColor. Don't need to set m_color
}

QColor Maemo5ColorDialog::selectedColor(){
    return m_color;
}

void Maemo5ColorDialog::updateColor() {
    int h = ui->hPicker->hue();
    int s = ui->svPicker->saturation();
    int v = ui->svPicker->value();

    m_color.setHsv(h,s,v);
    QPalette p = ui->color->palette();
    p.setColor(QPalette::Window,m_color);
    ui->color->setPalette(p);
    ui->color->repaint();
    ui->color->update();

    repaint();
}

void Maemo5ColorDialog::on_doneButton_clicked()
{
    accept();
}

void Maemo5ColorDialog::on_randomButton_clicked()
{
    QColor color(qrand() % 255 , qrand() % 255,qrand() % 255 );
    setCurrentColor(color);
}
