#include "paperbackground.h"
#include <QSharedData>
#include <QVariant>

class PaperBackgroundData : public QSharedData {
public:
    PaperBackgroundData() {}
    PaperBackgroundData(const PaperBackgroundData &other)
        : QSharedData(other), data(other.data) { }
    ~PaperBackgroundData() { }

    QVariant data;
};

PaperBackground::PaperBackground() : d(new PaperBackgroundData)
{
}

PaperBackground::PaperBackground(const PaperBackground &rhs) : d(rhs.d)
{
}

PaperBackground &PaperBackground::operator=(const PaperBackground &rhs)
{
    if (this != &rhs)
        d.operator=(rhs.d);
    return *this;
}

PaperBackground::~PaperBackground()
{
}

QString PaperBackground::tagName(){
    return "background";
}

QDomElement PaperBackground::createDomElement(QDomDocument &doc){
    QDomElement element = doc.createElement(tagName());

    /// @todo Implement another type
    QColor c = color();
    element.setAttribute("color",c.name());

    return element;
}

bool PaperBackground::setFromDomElement(QDomElement &elem){
    if (elem.tagName() != tagName())
        return false;

    QString color = elem.attribute("color","#FFFFFF");
    QColor c(color);

    d->data = c;

    return true;
}

void PaperBackground::setColor(QColor val){
    d->data = val;
}

QColor PaperBackground::color(){
    return d->data.value<QColor>();
}
