/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QPalette>
#include <QtCore>
#include "maemo5paperbackgrounddialog.h"
#include "ui_maemo5paperbackgrounddialog.h"
#include "maemo5colordialog.h"

Maemo5PaperBackgroundDialog::Maemo5PaperBackgroundDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Maemo5PaperBackgroundDialog)
{
    ui->setupUi(this);
}

Maemo5PaperBackgroundDialog::~Maemo5PaperBackgroundDialog()
{
    delete ui;
}

void Maemo5PaperBackgroundDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Maemo5PaperBackgroundDialog::setColor(QColor val){
//    qDebug() << __func__ << val;
    m_color = val;

    QString style = "border : 2px solid white; background: rgb(%1,%2,%3)";
    QColor color = m_color;
    style = style.arg(color.red()).arg(color.green()).arg(color.blue());
    ui->colorButton->setStyleSheet(style);
//    qDebug() << style;
}

QColor Maemo5PaperBackgroundDialog::color() {
    return m_color;
}

PaperBackground Maemo5PaperBackgroundDialog::selectBackground(){
    PaperBackground bg;
    bg.setColor(m_color);
    return bg;
}

void Maemo5PaperBackgroundDialog::on_confirmButton_clicked()
{
    accept();
}

void Maemo5PaperBackgroundDialog::on_colorButton_clicked()
{
    Maemo5ColorDialog dialog;
    dialog.setCurrentColor(m_color);

    if (dialog.exec() == QDialog::Accepted ){
        setColor(dialog.selectedColor());
    }
}
