#include <QtGui/QApplication>
#include <QTest>
#include <QtCore>

#include "basicunittests.h"

template <typename T>
void appendTestCase(QList<QObject*> &testCases , QObject *parent = 0){
    T *t = new T();
    t->setParent(parent);
    testCases << t;
}


int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setApplicationName("penpen");

    qsrand(time(0));

    QList<QObject*> testCases;

    appendTestCase<BasicUnitTests>(testCases);
    appendTestCase<StorageUnitTests>(testCases);

    QObject *object;
    bool error = false;
    foreach (object,testCases){
        error = QTest::qExec(object,argc,argv);
        if (error){
            qWarning() << "Error found!";
            break;
        }
    }

    if (!error){
        qWarning() << "All test cases passed!";
    }


}
