/**
  @author Ben Lau <xbenlau@gmail.com>
 */
#ifndef MAEMO5COLORHPICKER_H
#define MAEMO5COLORHPICKER_H

#include <QWidget>

/// Hue picker

class Maemo5ColorHPicker : public QWidget
{
    Q_OBJECT
public:
    explicit Maemo5ColorHPicker(QWidget *parent = 0);

    void setHue(int val);
    int hue();

signals:
    void hueChanged(int val);

public slots:

protected:
    void resizeEvent(QResizeEvent *);
    void paintEvent(QPaintEvent*);
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);

private:
    void updateMarker();
    int yToHue(int y);

    QPixmap background;
    int m_hue;
    int markerWidth;
    int markerPos;

};

#endif // MAEMO5COLORHPICKER_H
