#ifndef PAGEENTITY_H
#define PAGEENTITY_H

#include "storage.h"
#include "tables.h"

class PageEntity : public Entity
{
public:
    PageEntity();
    PageEntity(const PageEntity& other);

    virtual QString table() const;

    void setBookId(int val);
    int bookId();

    void setContent(QString val);
    QString content();

    void reset();
    bool save(Storage* storage);
    bool load(Storage* storage,int id);

    static QList<PageEntity> pagesOfBook(int bookId);

private:
    int m_bookId;
    QString m_content;

};

#endif // PAGEENTITY_H
