#ifndef PAPERBACKGROUND_H
#define PAPERBACKGROUND_H

#include <QSharedDataPointer>
#include <QColor>
#include <QPixmap>

#include "xmlioiface.h"

class PaperBackgroundData;

/// The background of paper

class PaperBackground : public XmlIOIface
{
public:
    PaperBackground();
    PaperBackground(const PaperBackground &);
    PaperBackground &operator=(const PaperBackground &);
    ~PaperBackground();

    virtual QString tagName();

    virtual QDomElement createDomElement(QDomDocument &doc);
    virtual bool setFromDomElement(QDomElement &elem);

    /// Set the background as a single pure color
    void setColor(QColor val);
    QColor color();

    /// Set a pixmap as the background
    void setPixmap(QPixmap val);
    QPixmap pixmap();

    /// Set a file name as the background
    void setFileName(QString val);
    QString fileName();

private:
    QSharedDataPointer<PaperBackgroundData> d;
};

#endif // PAPERBACKGROUND_H
