#ifndef PAPER_H
#define PAPER_H

#include <QObject>
#include <QSize>
#include <QGraphicsItem>
#include <QDomDocument>
#include <QGraphicsObject>
#include "paperbackground.h"

/// Paper class -  A drawing canvas with saving/loading to/from XML(Abstract class)
/**

  @remarks It is used by
 */
class Paper : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit Paper(QGraphicsItem *parent = 0);

    virtual QRectF boundingRect() const;
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    /// clear the content and reset to initial status
    virtual void clear();

    /// Get the drawing area of the paper on scene
    QRect rect() const;

    /// Set the drawing area of the paper on scene
    void setRect(QRect val);

    bool isResizable();
    void setResizable(bool val);

    bool dirty();

    virtual bool setFromElement(QDomElement &element) = 0;
    virtual QDomElement createElement(QDomDocument &doc) = 0;

    /// Take a snapshot of paper to target
    /**
      @remarks The content of snapshot is determined by the subclass , which may not contains the content of whole paper.
     */
    virtual void snapshot(QPainter * painter, QRectF &target) = 0;

    /// Set the background of paper
    void setBackground(PaperBackground val);

    PaperBackground background();

signals:

public slots:
    void setDirty(bool val = true);

protected:

private:
    bool m_resizable;
    QRect m_rect;
    bool m_dirty;


    PaperBackground m_background;
};

/// Basic sketch page
class SketchPaper : public Paper {
public:
    explicit SketchPaper(QGraphicsItem * parent = 0);
    ~SketchPaper();

    virtual QRectF boundingRect() const;
    virtual void clear();

    virtual bool setFromElement(QDomElement &element);
    virtual QDomElement createElement(QDomDocument &doc);
    virtual void snapshot(QPainter * painter, QRectF &target);

private:

};

#endif // PAPER_H
