#ifndef ERASER_H
#define ERASER_H

#include <QGraphicsObject>

class Eraser : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit Eraser(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;

    void start(QGraphicsItem* canvas);

    void stop();

signals:
    /// It is emitted when an item is erased
    void erased();

public slots:

protected:
    virtual bool sceneEventFilter ( QGraphicsItem * watched, QEvent * event);

private:
    QGraphicsItem* m_canvas;
};

#endif // ERASER_H
