#include <QtCore>
#include "tables.h"

Entity::Entity() {
    m_id = -1;
}

int Entity::id() const{
    return m_id;
}

void Entity::setId(int val){
    m_id = val;
}

int Entity::count(Storage* storage) const{
    int c = -1;
    QSqlQuery query = storage->query();

    QString sql = QString("SELECT count(id) from %1;").arg(table());
    query.prepare(sql);

    query.exec();

    if (query.next()) {
        c = query.value(0).toInt();
    }

    return c;
}

void Entity::remove(){

    if (m_id < 0)
        return;
    QSqlQuery query = Storage::instance()->query();

    QString sql = QString("delete from %1 where id = :id;").arg(table());

    query.prepare(sql);
    query.bindValue(":id",m_id);
    if (query.exec()){
        m_id = -1;
    }
}

/* BookEntity */
BookEntity::BookEntity(){
    m_number = 0;
    m_titlePaperId = -1;
}

QString BookEntity::table() const{
    return "book";
}

QString BookEntity::catalog(){
    return m_catalog;
}

void BookEntity::setCatalog(QString val){
    m_catalog = val;
}

bool BookEntity::save(Storage* storage){
    int m_id = id();
    QString sql;
    QSqlQuery query = storage->query();

    if (m_id > 0) {
        sql = "REPLACE INTO book (id,titlePaperId,number,catalog) values (:id,:titlePaperId,:number,:catalog);";
    } else {
        sql = "REPLACE INTO book (titlePaperId,number,catalog) values (:titlePaperId,:number,:catalog);";
    }

    query.prepare(sql);
    if (m_id > 0)
        query.bindValue(":id",m_id);
    query.bindValue(":titlePaperId",m_titlePaperId);
    query.bindValue(":number",m_number);
    query.bindValue(":catalog",m_catalog);

    bool res = query.exec();
    if (res) {
        if (m_id <= 0)
            setId( query.lastInsertId().toInt() );
    } else {
        qDebug() << "Failed to execute" << query.executedQuery();
    }
    return res;
}

bool BookEntity::load(Storage* storage,int id){
    bool res = false;
    QSqlQuery query = storage->query();

    query.prepare("SELECT titlePaperId,number,catalog from book where id = :id limit 1;");
    query.bindValue("id",id);

    query.exec();
    if (query.next()) {
        m_titlePaperId = query.value(0).toInt();
        m_number = query.value(1).toInt();
        m_catalog = query.value(2).toString();
        setId(id);
        res = true;
    }

    return res;
}
