#ifndef SKETCHITEM_H
#define SKETCHITEM_H

#include <QString>

#include <QDomDocument>
#include <QDomElement>

/// Interface to sketchable item (e.g stroke)

class SketchItem
{
public:
    virtual QString tagName() = 0;

    virtual QDomElement createDomElement(QDomDocument &doc) = 0;
    virtual bool setFromDomElement(QDomElement &elem) = 0;


};

#endif // SKETCHITEM_H
