#ifndef PAGE_H
#define PAGE_H

#include <QPointer>
#include <QDomDocument>
#include <QObject>
#include "paper.h"
#include "storage.h"
#include "pageentity.h"

/// Page is a collection of papers for specific presentation method

class Page : public QObject
{
    Q_OBJECT
public:
    explicit Page(QObject *parent = 0);

    virtual bool setFromXml(QDomDocument &doc) = 0;
    virtual QDomDocument toXml() = 0;

signals:

public slots:

private:

};

/// A standard page is the most common used page type. It only consists of a title and content paper

class StandardPage : public Page {
    Q_OBJECT
public:
    explicit StandardPage(QObject *parent = 0);
    ~StandardPage();

    void newPage(int bookId);
    bool load(int pageId);
    bool save(Paper *paper);
    void clear();
    void remove();

    /// The content paper
    Paper* content();
    PageEntity *entity();

    virtual bool setFromXml(QDomDocument &doc);
    virtual QDomDocument toXml();

private:
    PageEntity m_entity;

    /// The content paper
    QPointer<Paper> m_content;

    QRect defaultRect;

};

#endif // PAGE_H
