#include "feedinterface.h"
#include <QString>
#include <QFile>

QString FeedEntry::getBody() const
{
    if (m_bodyfile.length() == 0) {
        return m_body;
    }

    QFile f(m_bodyfile);
    f.open(QIODevice::ReadOnly);
    QByteArray bytes = f.readAll();
    QString res = QString::fromUtf8(bytes);
    return res;
}

void FeedEntry::setBodyString(QString body)
{
    m_body = body;
    m_bodyfile.clear();
}

void FeedEntry::setBodyFile(QString fname)
{
    m_bodyfile = fname;
}

IFeedBundle::~IFeedBundle()
{
}

IFeed::~IFeed()
{
}
