/*
 * (C) notaz, 2010
 *
 * This work is licensed under the terms of the GNU GPLv2 or later.
 * See the COPYING file in the top-level directory.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "plugin_lib.h"
#include "menu.h"
#include "pcnt.h"
#include "../libpcsxcore/new_dynarec/new_dynarec.h"

void *pl_fbdev_buf;

static int pl_fbdev_w, pl_fbdev_h, pl_fbdev_bpp;
int flip_cnt,vsync_cnt, flips_per_sec, tick_per_sec;
extern float fps_cur; // XXX

static int get_cpu_ticks(void)
{
	static unsigned long last_utime;
	static int fd;
	unsigned long utime, ret;
	char buf[128];

	if (fd == 0)
		fd = open("/proc/self/stat", O_RDONLY);
	lseek(fd, 0, SEEK_SET);
	buf[0] = 0;
	read(fd, buf, sizeof(buf));
	buf[sizeof(buf) - 1] = 0;

	sscanf(buf, "%*d %*s %*c %*d %*d %*d %*d %*d %*u %*u %*u %*u %*u %lu", &utime);
	ret = utime - last_utime;
	last_utime = utime;
	return ret;
}

static void print_fps(void)
{
	if (pl_fbdev_bpp == 16)
		pl_text_out16(2, pl_fbdev_h - 10, "%2d %4.1f", flips_per_sec, fps_cur);
}

static void print_cpu_usage(void)
{
	if (pl_fbdev_bpp == 16)
		pl_text_out16(pl_fbdev_w - 28, pl_fbdev_h - 10, "%3d", tick_per_sec);
}


void pl_text_out16(int x, int y, const char *texto, ...)
{
	va_list args;
	char    buffer[256];

	va_start(args, texto);
	vsnprintf(buffer, sizeof(buffer), texto, args);
	va_end(args);

	printf (buffer);
}

static void pl_get_layer_pos(int *x, int *y, int *w, int *h)
{
	*x = 0;
	*y = 0;
	*w = 800;
	*h = 640;
}

extern int UseFrameSkip; // hmh

const struct rearmed_cbs pl_rearmed_cbs = {
	pl_get_layer_pos,
	pl_fbdev_open,
	pl_fbdev_set_mode,
	pl_fbdev_flip,
	pl_fbdev_close,
	&UseFrameSkip,
};


#define MAX_LAG_FRAMES 3

#define tvdiff(tv, tv_old) \
	((tv.tv_sec - tv_old.tv_sec) * 1000000 + tv.tv_usec - tv_old.tv_usec)
// assumes us < 1000000
#define tvadd(tv, us) { \
	tv.tv_usec += us; \
	if (tv.tv_usec >= 1000000) { \
		tv.tv_usec -= 1000000; \
		tv.tv_sec++; \
	} \
}
static float vsps_cur;
int pl_frame_interval;

void pl_frame_limit(void){
	
	
	static struct timeval tv_old, tv_expect;
	struct timeval now;
	int diff;

	vsync_cnt++;

	/* doing input here because the pad is polled
	 * thousands of times per frame for some reason */
	
	pcnt_end(PCNT_ALL);
	gettimeofday(&now, 0);

	if (now.tv_sec != tv_old.tv_sec) {
		diff = tvdiff(now, tv_old);
		vsps_cur = 0.0f;
		if (0 < diff && diff < 2000000)
			vsps_cur = 1000000.0f * vsync_cnt / diff;
		flips_per_sec = flip_cnt;
		vsync_cnt = flip_cnt = 0;
		tv_old = now;

	}
#ifdef PCNT
	static int ya_vsync_count;
	if (++ya_vsync_count == PCNT_FRAMES) {
		pcnt_print(vsps_cur);
		ya_vsync_count = 0;
	}
#endif

	if (!(g_opts & 1)) {
		tvadd(tv_expect, pl_frame_interval);
		diff = tvdiff(tv_expect, now);
		if (diff > MAX_LAG_FRAMES * pl_frame_interval || diff < -MAX_LAG_FRAMES * pl_frame_interval) {
			//printf("pl_frame_limit reset, diff=%d, iv %d\n", diff, pl_frame_interval);
			tv_expect = now;
		}
		else if (diff > pl_frame_interval) {
			// yay for working usleep on pandora!
			//printf("usleep %d\n", diff - pl_frame_interval / 2);
			usleep(diff - pl_frame_interval / 2);
		}
	}

	pcnt_start(PCNT_ALL);
	
}