/***************************************************************************
 *   Copyright (C) 2007 Ryan Schultz, PCSX-df Team, PCSX team              *
 *   schultz.ryan@gmail.com, http://rschultz.ath.cx/code.php               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02111-1307 USA.            *
 ***************************************************************************/

/*
* Internal PSX HLE functions.
*/

#include "psxhle.h"

static u32 hleDummy(u32 cycles) {
	psxRegs.pc = psxRegs.GPR.n.ra;

#ifndef NOPSXREC
	if (Config.Cpu) {
#endif
		psxBranchTest();
		psxRegs.cycle += cycles;
		return psxRegs.pc;
#ifndef NOPSXREC
	}
	return psxBranchTest_rec(cycles, psxRegs.pc);
#endif
}

static u32 hleA0(u32 cycles) {
	u32 call = psxRegs.GPR.n.t1 & 0xff;

	if (biosA0[call]) biosA0[call]();

#ifndef NOPSXREC
	if (Config.Cpu) {
#endif
		psxBranchTest();
		psxRegs.cycle += cycles;
		return psxRegs.pc;
#ifndef NOPSXREC
	}
	return psxBranchTest_rec(cycles, psxRegs.pc);
#endif
}

static u32 hleB0(u32 cycles) {
	u32 call = psxRegs.GPR.n.t1 & 0xff;

	if (biosB0[call]) biosB0[call]();

#ifndef NOPSXREC
	if (Config.Cpu) {
#endif
		psxBranchTest();
		psxRegs.cycle += cycles;
		return psxRegs.pc;
#ifndef NOPSXREC
	}
	return psxBranchTest_rec(cycles, psxRegs.pc);
#endif
}

static u32 hleC0(u32 cycles) {
	u32 call = psxRegs.GPR.n.t1 & 0xff;

	if (biosC0[call]) biosC0[call]();

#ifndef NOPSXREC
	if (Config.Cpu) {
#endif
		psxBranchTest();
		psxRegs.cycle += cycles;
		return psxRegs.pc;
#ifndef NOPSXREC
	}
	return psxBranchTest_rec(cycles, psxRegs.pc);
#endif
}

static void hleBootstrap(u32 cycles) { // 0xbfc00000
	SysPrintf("hleBootstrap\n");
	CheckCdrom();
	LoadCdrom();
	SysPrintf("CdromLabel: \"%s\": PC = %8.8lx (SP = %8.8lx)\n", CdromLabel, psxRegs.pc, psxRegs.GPR.n.sp);
#ifndef NOPSXREC
	if (Config.Cpu) {
#endif
		psxBranchTest();
		psxRegs.cycle += cycles;
		return psxRegs.pc;
#ifndef NOPSXREC
	}
	return psxBranchTest_rec(cycles, psxRegs.pc);
#endif
}

typedef struct {                   
	u32 _pc0;      
	u32 gp0;      
	u32 t_addr;   
	u32 t_size;   
	u32 d_addr;   
	u32 d_size;   
	u32 b_addr;   
	u32 b_size;   
	u32 S_addr;
	u32 s_size;
	u32 _sp,_fp,_gp,ret,base;
} EXEC;

static void hleExecRet() {
	EXEC *header = (EXEC*)PSXM(psxRegs.GPR.n.s0);

	SysPrintf("ExecRet %x: %x\n", psxRegs.GPR.n.s0, header->ret);

	psxRegs.GPR.n.ra = header->ret;
	psxRegs.GPR.n.sp = header->_sp;
	psxRegs.GPR.n.s8 = header->_fp;
	psxRegs.GPR.n.gp = header->_gp;
	psxRegs.GPR.n.s0 = header->base;

	psxRegs.GPR.n.v0 = 1;
	psxRegs.pc = psxRegs.GPR.n.ra;
}

void (*psxHLEt[256])() = {
	hleDummy, hleA0, hleB0, hleC0,
	hleBootstrap, hleExecRet,
	hleDummy, hleDummy
};
