/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Marcos Morais <morais@dee.ufcg.edu.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *          Walter Guerra <wguerra@ee.ufcg.edu.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef NM_WLAN_UTILS_H
#define NM_WLAN_UTILS_H

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#define DBUS_SERVICE_ICD                    "com.nokia.icd"
#define DBUS_PATH_ICD                       "/com/nokia/icd"
#define DBUS_PATH_ICD_UI                    "/com/nokia/icd_ui"
#define DBUS_INTERFACE_ICD_UI               "com.nokia.icd_ui"
#define DBUS_INTERFACE_ICD                  "com.nokia.icd"

/* ICD methods */
#define ICD_CONNECT                         "connect"
#define ICD_UI_DISCONNECT                   "disconnect"
#define ICD_GETIPINFO                       "get_ipinfo"

#define NM_WLAN_UTILS_TYPE            (nm_wlan_utils_get_type ())
#define NM_WLAN_UTILS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_WLAN_UTILS_TYPE, NmWlanUtils))
#define NM_WLAN_UTILS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_WLAN_UTILS_TYPE, NmWlanUtilsClass))
#define IS_WLAN_BT_UTILS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_WLAN_UTILS_TYPE))
#define IS_WLAN_BT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_WLAN_UTILS_TYPE))
#define NM_WLAN_UTILS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_WLAN_UTILS_TYPE, NmWlanUtilsClass))

typedef struct _NmWlanUtils      NmWlanUtils;
typedef struct _NmWlanUtilsClass NmWlanUtilsClass;

struct _NmWlanUtilsClass
{
    GObjectClass parent_class;
};

struct _NmWlanUtils
{
    GObject parent;
};

GType       nm_wlan_utils_get_type (void);
NmWlanUtils*  nm_wlan_utils_new      (void);

gboolean nm_wlan_utils_is_active(void);
gboolean nm_wlan_utils_activate(void);
gboolean nm_wlan_utils_deactivate(void);
gboolean nm_wlan_utils_activate_dbus (NmWlanUtils *);
gboolean nm_wlan_utils_deactivate_dbus (NmWlanUtils *);


#endif
