/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *          Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_USB_SETUP_H__
#define __NM_USB_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS
#define NM_USB_DEFAULT_IP      "192.168.2.15"
#define NM_USB_DEFAULT_GATEWAY "192.168.2.14"
#define NM_USB_DEFAULT_MASK    "255.255.255.0"

#define NM_USB_COMBO_DEFAULT            0
#define NM_USB_COMBO_MANUAL             1

#define NM_USB_MASS_STORAGE_LABEL         "Mass Storage"
#define NM_USB_NETWORK_LABEL              "Network"
#define NM_USB_PC_SUITE_LABEL             "PC Suite"

#define NM_USB_MASS_STORAGE         0
#define NM_USB_NETWORK              1
#define NM_USB_PC_SUITE             3

#define NM_USB_SETUP_TYPE            (nm_usb_setup_get_type ())
#define NM_USB_SETUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_USB_SETUP_TYPE, NmUsbSetup))
#define NM_USB_SETUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_USB_SETUP_TYPE, NmUsbSetupClass))
#define IS_NM_USB_SETUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_USB_SETUP_TYPE))
#define IS_NM_USB_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_USB_SETUP_TYPE))
#define NM_USB_SETUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_USB_SETUP_TYPE, NmUsbSetupClass))

typedef struct _NmUsbSetup      NmUsbSetup;
typedef struct _NmUsbSetupClass NmUsbSetupClass;

struct _NmUsbSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmUsbSetup
{
    NmConnWidget parent;
};

GType       nm_usb_setup_get_type (void);
GtkWidget*  nm_usb_setup_new      (gchar *env);
gboolean nm_usb_setup_mode_is_network (NmUsbSetup *);
gboolean nm_usb_setup_mode_is_mass_storage (NmUsbSetup *);
gboolean nm_usb_setup_mode_is_host (NmUsbSetup *);
gboolean usb_setup_check_enabled (NmUsbSetup *);
void nm_usb_setup_enable (NmUsbSetup *self, gchar* mode);
void nm_usb_setup_fill_widget(NmUsbSetup *self);
gboolean nm_usb_setup_apply_changes (NmConnWidget *);
gboolean nm_usb_setup_activate_environment (gchar *);
void nm_usb_setup_save_changes (NmUsbSetup *);


G_END_DECLS

#endif
