/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_BT_SETUP_H__
#define __NM_BT_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"
// #include "nm_bt_utils.h"

G_BEGIN_DECLS

#define NM_BT_DEFAULT_IP            "192.168.3.15"
#define NM_BT_DEFAULT_GATEWAY       "192.168.3.14"
#define NM_BT_DEFAULT_MASK          "255.255.255.0"
#define NM_BT_DEFAULT_MAC           "00:00:00:00:00:00"

#define NM_BT_COMBO_DEFAULT         0
#define NM_BT_COMBO_MANUAL          1

#define NM_BT_SETUP_TYPE            (nm_bt_setup_get_type ())
#define NM_BT_SETUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_BT_SETUP_TYPE, NmBtSetup))
#define NM_BT_SETUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  NM_BT_SETUP_TYPE, NmBtSetupClass))
#define IS_NM_BT_SETUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_BT_SETUP_TYPE))
#define IS_NM_BT_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  NM_BT_SETUP_TYPE))
#define NM_BT_SETUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  NM_BT_SETUP_TYPE, NmBtSetupClass))

typedef struct _NmBtSetup      NmBtSetup;
typedef struct _NmBtSetupClass NmBtSetupClass;

struct _NmBtSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmBtSetup
{
    NmConnWidget parent;
};

GType nm_bt_setup_get_type (void);
GtkWidget* nm_bt_setup_new (gchar *env);
void nm_bt_setup_enable (NmBtSetup *, gboolean);
gboolean nm_bt_setup_is_enabled (NmBtSetup *);
gboolean bt_setup_check_enabled (NmBtSetup *);
void nm_bt_setup_fill_widget(NmBtSetup *);
gboolean nm_bt_setup_apply_changes (NmConnWidget *);
gboolean nm_bt_setup_activate_environment (gchar *);
void nm_bt_setup_save_changes (NmBtSetup *);

G_END_DECLS

#endif
