/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Kyller Gorgonio <kyllercg@gmail.com>
 *          Marcos Morais <morais@dee.ufcg.edu.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_IFACES_UTILS_H__
#define __NM_IFACES_UTILS_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NM_IFACES_FILE                  "/etc/network/interfaces"
#define NM_IFACES_USB_ST                "usb"
#define NM_IFACES_BT_ST                 "bluetooth"
#define NM_IFACES_USB_REGEX             "iface usb0"
#define NM_IFACES_BT_REGEX              "iface bnep0"
#define NM_IFACES_R_MODE                "r"
#define NM_IFACES_RW_MODE               "w+"
#define NM_IFACES_ADDRESS_ST            "address"
#define NM_IFACES_NETMASK_ST            "netmask"
#define NM_IFACES_GATEWAY_ST            "gateway"
#define NM_IFACES_IP                    "[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+"
#define NM_IFACES_WHITE                 " \t\n"

GList * nm_ifaces_utils_read_file (const gchar *);
gboolean nm_ifaces_utils_save_file (GList *, const gchar *);
gchar * nm_ifaces_utils_find_line (GList *, const gchar *, const gchar *);
gboolean nm_ifaces_utils_match (const gchar *, const gchar *);
guint nm_ifaces_utils_find_line_number (GList *, const gchar *, const gchar *);
void nm_ifaces_utils_change (GList *, const gchar *, const gchar *,
                              const gchar *);
gchar * nm_ifaces_utils_get_ip (GList *, const gchar *, const gchar *);
gboolean nm_ifaces_utils_save_config (const gchar *, const gchar *,
                                       const gchar *, const gchar *);
gboolean nm_ifaces_utils_save_config_e (const gchar *, const gchar *,
                                         const gchar *, const gchar *);

G_END_DECLS

#endif
