/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_BT_SEARCH_DIALOG_H__
#define __NM_BT_SEARCH_DIALOG_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

#include "nm_bt_utils.h"

G_BEGIN_DECLS

#define NM_BT_SEARCH_DIALOG_TYPE            (nm_bt_search_dialog_get_type ())
#define NM_BT_SEARCH_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_BT_SEARCH_DIALOG_TYPE, NmBtSearchDialog))
#define NM_BT_SEARCH_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_BT_SEARCH_DIALOG_TYPE, NmBtSearchDialogClass))
#define IS_NM_BT_SEARCH_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_BT_SEARCH_DIALOG_TYPE))
#define IS_NM_BT_SEARCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_BT_SEARCH_DIALOG_TYPE))
#define NM_BT_SEARCH_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_BT_SEARCH_DIALOG_TYPE, NmBtSearchDialogClass))

typedef struct _NmBtSearchDialog      NmBtSearchDialog;
typedef struct _NmBtSearchDialogClass NmBtSearchDialogClass;

struct _NmBtSearchDialogClass
{
    GtkDialogClass parent_class;
};

struct _NmBtSearchDialog
{
    GtkDialog parent;
};

GType nm_bt_search_dialog_get_type (void);
GtkWidget* nm_bt_search_dialog_new (NmBtUtils *);

gboolean nm_bt_search_dialog_start_discovery (NmBtSearchDialog *);
gboolean nm_bt_search_dialog_stop_discovery (NmBtSearchDialog *);

gchar* nm_bt_search_dialog_get_selected_addr (NmBtSearchDialog *);
gchar* nm_bt_search_dialog_get_selected_name (NmBtSearchDialog *);

G_END_DECLS

#endif
