/*
 * Copyright (c) 2008, 2009 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Marcos Morais <morais@dee.ufcg.edu.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef NM_SETTINGS_H
#define NM_SETTINGS_H

#include <glib.h>
#include <glib-object.h>

#include "nm_usb_setup.h"
#include "nm_bt_setup.h"
#include "nm_wlan_setup.h"
#include "nm_internet_setup.h"

G_BEGIN_DECLS

#define _(String) gettext(String)

#define  NM_SETTINGS_ENABLE             "ENABLED"
#define  NM_SETTINGS_IP                 "IP"
#define  NM_SETTINGS_GATEWAY            "GATEWAY"
#define  NM_SETTINGS_MASK               "MASK"
#define  NM_SETTINGS_HOST               "HOST"
#define  NM_SETTINGS_MAC                "MAC"
#define  NM_SETTINGS_DHCPD              "DHCPD"


#define  NM_SETTINGS_MODE               "MODE"
#define  NM_SETTINGS_MODE_BASIC         "BASIC"
#define  NM_SETTINGS_MODE_ADVANCED      "ADVANCED"

#define NM_SETTINGS_FILE                "pc-connectivity-manager.conf"
#define NM_SETTINGS_DEFAULT_ENV         NULL

#define NM_SETTINGS_GROUP               "PC-CONNECTIVITY-CONFIG"
#define NM_USB_SETTINGS_GROUP           "USB"
#define NM_BT_SETTINGS_GROUP            "BLUETOOTH"
#define NM_WLAN_SETTINGS_GROUP          "WLAN"
#define NM_INTERNET_SETTINGS_GROUP      "INTERNET"
#define NM_SETTINGS_ENVIRONMENT_GROUP   "ENVIRONMENTS"
#define NM_SBRSH_SETTINGS_GROUP         "SBRSH"
#define NM_UNFS_SETTINGS_GROUP          "UNFS"
#define NM_VNC_SETTINGS_GROUP           "VNC"
#define NM_SAMBA_SETTINGS_GROUP         "SAMBA"

#define  NM_WLAN_SETTINGS_ESSID         "ESSID"
#define  NM_WLAN_SETTINGS_NAME          "NAME"
#define  NM_WLAN_SETTINGS_WEPKEY        "WEPKEY"

#define NM_USB_SETTINGS_MODE            "MODE"

#define NM_SETTINGS_ENVIRONMENT_LIST    "LIST"
#define NM_SETTINGS_ENVIRONMENT_DEFAULT "DEFAULT"

#define NM_SBRSH_PORT                   "PORT"
#define NM_SETTINGS_NOSANDBOX           "NOSANDBOX"
#define NM_SETTINGS_ALLOWROOT           "ALLOWROOT"
#define NM_SETTINGS_DEBUG               "DEBUG"

#define NM_UNFS_PORT                    "PORT"
#define NM_UNFS_SINGLEUSER              "SINGLEUSER"

#define NM_VNC_LOOP                     "LOOP"
#define NM_VNC_PORT                     "PORT"

#define NM_SAMBA_WORKGROUP              "WORKGROUP"
#define NM_SAMBA_USER                   "USER"
#define NM_SAMBA_PASSWD                 "PASSWD"
#define NM_SAMBA_READ_ONLY              "READ_ONLY"

#define NM_SETTINGS_TYPE            (nm_settings_get_type ())
#define NM_SETTINGS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_SETTINGS_TYPE, NmSettings))
#define NM_SETTINGS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_SETTINGS_TYPE, NmSettingsClass))
#define IS_NM_SETTINGS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_SETTINGS_TYPE))
#define IS_NM_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_SETTINGS_TYPE))
#define NM_SETTINGS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_SETTINGS_TYPE, NmSettingsClass))

typedef struct _NmSettings      NmSettings;
typedef struct _NmSettingsClass NmSettingsClass;

struct _NmSettingsClass
{
    GObjectClass parent_class;
};

struct _NmSettings
{
    GObject parent;
};

GType        nm_settings_get_type (void);
NmSettings*  nm_settings_new      (void);

void     nm_settings_set_value (NmSettings *, const gchar *env, const gchar *group, const gchar *key, const gchar *value);
gchar*   nm_settings_get_value (NmSettings *, const gchar *env, const gchar *group, const gchar *key);
void     nm_settings_set_boolean (NmSettings *, const gchar *env, const gchar *group, const gchar *key, gboolean value);
gboolean nm_settings_get_boolean (NmSettings *, const gchar *env, const gchar *group, const gchar *key);
void     nm_settings_set_string_list (NmSettings *, const gchar *env, const gchar *group, const gchar *key, const gchar** value, gsize lenght);
gchar**  nm_settings_get_string_list (NmSettings *, const gchar *env, const gchar *group, const gchar *key, gsize *lenght);
void     nm_settings_save (NmSettings *);
gboolean nm_settings_start (NmSettings *self);
gboolean nm_settings_set_defaults (NmSettings *self);

/* Get the singleton instance pointer */
NmSettings* nm_settings_get_context(void);

G_END_DECLS

#endif

