// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/
// Include C header files before Qt header files
// to avoid name collisions with Qt's reserved words
// such as "signal".
//
// Qt header files

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QContactDetailFilter>
#include <QContactGuid>
#include <QContactIntersectionFilter>
#include <QContactPhoneNumber>
#include <QContactThumbnail>
#include <QDebug>
#include <QDesktopServices>
#include <QErrorMessage>
#include <QFileDialog>
#include <QInputDialog>
#include <QListWidgetItem>
#include <QMessage>
#include <QMessageAddress>
#include <QMessageBox>
#include <QPixmap>
#include <QProcess>
#include <QSettings>
#include <QStandardItem>
#include <QStatusBar>
#include <QtCore/QCoreApplication>
#include <QtDebug>
#include <QTimer>
#include <QUrl>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow),
      allContactsIndex(0),
      emergencyContactsIndex(0),
      gpsUpdateIntervalSet(false),
      runApplicationOnPanic(false),
      runThisApplicationOnPanic(""),
      writeDefaultSettings(false),
      allContactsRemoveRequest(0)
{
    ui->setupUi(this);
    ui->panicButton->setStyleSheet("color:green");

    // Draw the icon on the right instead of the left
    chooserDialog.setLayoutDirection(Qt::RightToLeft);
    chooserDialog.hide();

    QSettings settings("Whatever", "PanicButton", this);
    emergencyContacts = settings.value("Emergency Contacts").toMap();
    panicMessage = settings.value("Panic Message", tr("This is my location")).toString();
    gpsUpdateInterval = settings.value("GPS Update Interval", 60).toInt();
    deleteAllContactsOnPanic = settings.value("Delete Contacts on Panic", "false").toBool();
    runApplicationOnPanic = settings.value("Run Application On Panic", "false").toBool();
    runThisApplicationOnPanic = settings.value("Run This Application On Panic", "").toString();

    ui->actionDelete_All_Contacts_On_Panic->setChecked(deleteAllContactsOnPanic);

    ui->actionRun_Application_On_Panic->setEnabled(false);

    /*
      Don't invoke the application selection dialog in
      on_actionRun_Application_On_Panic_toggled() at
      startup time because that would confuse the user.
      The dialog will appear before the panic button and
      the menu.

      To accomplish this, make the value of runApplicationOnPanic
      depend on the non-empty value of runThisApplicationOnPanic.
    */
    if (runThisApplicationOnPanic.isEmpty())
        runApplicationOnPanic = false;

    ui->actionRun_Application_On_Panic->setChecked(runApplicationOnPanic);

    messageService = new QMessageService(this);
    if (messageService) {
        connect(messageService, SIGNAL(stateChanged(QMessageService::State)),
                this, SLOT(messageService_stateChanged(QMessageService::State)));
        messageServiceReady = true;
    }

    connect(&chooserDialog, SIGNAL(accepted()), this, SLOT(chooserDialog_accepted()));
    connect(&chooserDialog, SIGNAL(rejected()), this, SLOT(chooserDialog_rejected()));

    connect(&allContactsFetchRequest, SIGNAL(stateChanged(QContactAbstractRequest::State)),
            this, SLOT(allContactsFetchRequest_stateChanged(QContactAbstractRequest::State)));
    connect(&allContactsFetchRequest, SIGNAL(resultsAvailable()),
            this, SLOT(allContactsFetchRequest_resultsAvailable()));

    allContactsFetchRequest.setManager(&cm);

    connect(&emergencyContactsFetchRequest, SIGNAL(stateChanged(QContactAbstractRequest::State)),
            this, SLOT(emergencyContactsFetchRequest_stateChanged(QContactAbstractRequest::State)));
    connect(&emergencyContactsFetchRequest, SIGNAL(resultsAvailable()),
            this, SLOT(emergencyContactsFetchRequestUpdate_resultsAvailable()));

    emergencyContactsFetchRequest.setManager(&cm);
    QTimer::singleShot(1000, this, SLOT(contactGPS()));
    QTimer::singleShot(1000, this, SLOT(fetchEmergencyContacts()));

    if (deleteAllContactsOnPanic)
        QTimer::singleShot(1000, this, SLOT(createAllContactsRemoveRequest()));
}

MainWindow::~MainWindow()
{
    QSettings settings("Whatever", "PanicButton", this);

    // TODO: Constants for the default settings.
    if (writeDefaultSettings) {
        emergencyContacts.clear();
        panicMessage = tr("This is my location");
        gpsUpdateInterval = 60;
        deleteAllContactsOnPanic = false;
        runApplicationOnPanic = false;
        runThisApplicationOnPanic = "";
    }

    settings.setValue("Emergency Contacts", emergencyContacts);
    settings.setValue("Panic Message", panicMessage);
    settings.setValue("GPS Update Interval", gpsUpdateInterval);
    settings.setValue("Delete Contacts on Panic", deleteAllContactsOnPanic);
    settings.setValue("Run Application On Panic", runApplicationOnPanic);
    settings.setValue("Run This Application On Panic", runThisApplicationOnPanic);

    delete ui;
    delete messageService;
    delete source;
    delete allContactsRemoveRequest;
}

void MainWindow::addToChooserDialog(QContactFetchRequest &request)
{
    QList<QContact> results = request.contacts();
    for (; allContactsIndex < results.size(); allContactsIndex++) {
        QContact contact = results.at(allContactsIndex);
        QContactGuid guid = contact.detail<QContactGuid>();
        QList<QContactPhoneNumber> numbers =
                contact.details<QContactPhoneNumber>();

        // Choose only mobile numbers in numbers.
        foreach(QContactPhoneNumber number, numbers) {
            if (number.subTypes().contains(QContactPhoneNumber::SubTypeMobile)) {

                QStandardItem *item = new QStandardItem(contact.displayLabel());

                QContactThumbnail thumbnail = contact.detail<QContactThumbnail>();
                item->setIcon(QIcon(QPixmap::fromImage(thumbnail.thumbnail())));
                item->setData(guid.guid(), Qt::UserRole);
                // Alignment trick:
                // Make the text flush left.  This requires Qt::AlignAbsolute
                // because we set chooserDialog's layout direction to Qt::RightToLeft
                // in the ctor.
                item->setTextAlignment(Qt::AlignLeft|Qt::AlignVCenter|Qt::AlignAbsolute);
                allContacts.insert(guid.guid(), number.number());
                chooserDialog.insertItem(item, emergencyContacts.contains(guid.guid()));
            }
        }
    }

    qDebug() << "addToChooserDialog(): allContactsIndex=" << allContactsIndex;
}

void MainWindow::addToEmergencyContacts(QContactFetchRequest &request)
{
    QList<QContact> contacts = request.contacts();
    //    qDebug()<< "emergencyContacts: some results!";
    for(; emergencyContactsIndex < contacts.length(); emergencyContactsIndex++) {
        QContactGuid guid = contacts.at(emergencyContactsIndex).detail<QContactGuid>();
        QList<QContactPhoneNumber> numbers =
                contacts.at(emergencyContactsIndex).details<QContactPhoneNumber>();

        qDebug() << "addToEmergencyContacts(): Retrieved contact:" << guid << " "
                 << contacts.at(emergencyContactsIndex).displayLabel();

        // Choose only mobile numbers in numbers.
        foreach(QContactPhoneNumber number, numbers) {
            if (number.subTypes().contains(QContactPhoneNumber::SubTypeMobile)) {
                emergencyContacts.insert(guid.guid(), number.number());
                qDebug() << "Mobile number:" << guid << " " << number;
            }
        }
    }
}

void MainWindow::allContactsFetchRequest_resultsAvailable()
{
    QContactFetchRequest *request = qobject_cast<QContactFetchRequest*>(QObject::sender());
    //    qDebug()<< "allContacts: some results!";

     // TODO: QProgressDialog
    addToChooserDialog(*request);
}

void MainWindow::allContactsFetchRequest_stateChanged(QContactAbstractRequest::State newState) {
    QContactFetchRequest *request = qobject_cast<QContactFetchRequest*>(QObject::sender());

    // TALMAGE: This might not be the right way to handle
    // an error in FinishedState
    if (newState == QContactAbstractRequest::FinishedState) {
        if (request->error() != QContactManager::NoError) {
            qDebug() << "Error" << request->error() << "occurred during fetch request!";
            return;
        }

        addToChooserDialog(*request);
        allContactsIndex = 0;

        if (chooserDialog.count() > 0) {
            chooserDialog.show();
        } else {
            QMessageBox::information(this, tr("No SMS-compatible contacts!"),
                                     tr("There are no contacts with mobile phones in your address book."));
        }
    } else if (newState == QContactAbstractRequest::CanceledState) {
        qDebug() << "Fetch operation canceled!";
    }

}

void MainWindow::allContactsRemoveRequest_stateChanged(QContactAbstractRequest::State)
{
}

bool MainWindow::buildEmergencyContactsFetchRequest()
{
    bool answer = false;
    if (emergencyContacts.size() > 0) {
        QContactIntersectionFilter *intersectionFilter = 0;
        QContactDetailFilter *detailFilter = 0;
        QList<QString> keys = emergencyContacts.keys();

        if (emergencyContacts.size() > 1) {
            // TODO: Track memory leak here
            intersectionFilter = new QContactIntersectionFilter();
        }

        // Make a QContactDetailFilter for the first emergencyContact
        //
        // If there is more than 1, then make a QContactIntersectionFilter
        // append() the QContactDetailFilter to it, make a QContactDetailFilter
        // for each of the remaining emergencyContacts, and append() each of
        // them to the QContactIntersectionFilter.
        //
        foreach(QString key, keys) {
            // TODO: Track memory leak here
            detailFilter = new QContactDetailFilter();
            detailFilter->setDetailDefinitionName(QContactGuid::DefinitionName, QContactGuid::FieldGuid);
            detailFilter->setValue(key);
            qDebug() << "Added guid " << key << " to filter for emergencyContactsFetchRequest";
            if (intersectionFilter) {
                intersectionFilter->append(*detailFilter);
            }
        }

        if (intersectionFilter) {
            emergencyContactsFetchRequest.setFilter(*intersectionFilter);
        } else {
            emergencyContactsFetchRequest.setFilter(*detailFilter);
        }

        answer = true;
    }

    return answer;
}

void MainWindow::chooserDialog_accepted()
{
    emergencyContacts.clear();
    QList<QStandardItem *> newEmergencyContacts = chooserDialog.selectedItems();
    foreach(QStandardItem *item, newEmergencyContacts) {
        QString guid = item->data(Qt::UserRole).toString();
        qDebug() << "accept(): Adding " << guid << ":"
                 << allContacts.value(guid) << " to emergencyContacts";
        emergencyContacts.insert(guid, allContacts.value(guid));
    }

    chooserDialog.clear();
    allContacts.clear();
}

void MainWindow::chooserDialog_rejected()
{
    // No change to emergencyContacts
    chooserDialog.clear();
    allContacts.clear();
}

void MainWindow::contactGPS()
{
    source  = QGeoPositionInfoSource::createDefaultSource(this);
    // TODO: schedule another attempt to createDefaultSource()
    // if this one fails.
    //
    // TODO: Display a yellow banner "Getting GPS fix"
    // until the first time positionUpdated() is called.
    if (source) {
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),
                this, SLOT(source_positionUpdated(QGeoPositionInfo)));
        source->startUpdates();
    }
}

void MainWindow::createAllContactsRemoveRequest()
{
    delete allContactsRemoveRequest;

    // TODO: Request contactIds asynchronously
    // TODO: QProgressDialog
    allContactsRemoveRequest = new QContactRemoveRequest(this);
    allContactsRemoveRequest->setContactIds(cm.contactIds());
    allContactsRemoveRequest->setManager(&cm);

    //    connect(allContactsRemoveRequest, SIGNAL(stateChanged(QContactAbstractRequest::State)),
    //            this, SLOT(allContactsRemoveRequestStateChanged(QContactAbstractRequest::State)));
}

void MainWindow::emergencyContactsFetchRequestUpdate_resultsAvailable()
{
    QContactFetchRequest *request = qobject_cast<QContactFetchRequest*>(QObject::sender());

    // TODO: QProgressDialog

    // TALMAGE: Must I check error() here?  Is it OK to assume that
    // error() == QContactManager::NoError will be handed to
    // emergencyContactsFetchRequestStateChanged() with
    // newState == QContactAbstractRequest::FinishedState?
    addToEmergencyContacts(*request);
}

void MainWindow::emergencyContactsFetchRequest_stateChanged(QContactAbstractRequest::State newState) {
    QContactFetchRequest *request = qobject_cast<QContactFetchRequest*>(QObject::sender());

    // TALMAGE: This might not be the right way to handle
    // an error in FinishedState
    if (newState == QContactAbstractRequest::FinishedState) {
        if (request->error() != QContactManager::NoError) {
            qDebug() << "Error" << request->error() << "occurred during fetch request!";
            return;
        }

        addToEmergencyContacts(*request);
        emergencyContactsIndex = 0;
    } else if (newState == QContactAbstractRequest::CanceledState) {
        qDebug() << "Fetch operation canceled!";
    }
}

void MainWindow::fetchEmergencyContacts()
{
    if (buildEmergencyContactsFetchRequest()) {
        // TODO: Display a yellow banner "Getting stored emergency contacts from contact manager"
        // until emergencyContactsFetchRequestStateChanged() is called with
        // QContactAbstractRequest::FinishedState
        emergencyContactsFetchRequest.start();
    }
}

void MainWindow::messageService_stateChanged(QMessageService::State newState)
{
    qDebug() << "messageServiceStateChanged() " << newState;

    messageServiceReady = false;

    if (QMessageService::FinishedState == newState) {
        messageServiceReady = true;
        sendMessage();
    }
}

void MainWindow::on_actionAbout_Panic_Button_triggered() {
    QMessageBox::about(this,
                       tr("About Panic Button"),
                       tr("<h1>Panic Button &copy; 2011 by David Talmage</h1><p>Version 0.4</p>\
                          <p>Send your location to your important people when you press the Panic Button.</p>\
                          <p>Distribution of this free software is governed by the GNU Public License version x.y.</p>\
                          <p>Provided AS IS with NO WARRANTY OF ANY KIND."));
}

void MainWindow::on_actionClear_Contacts_triggered()
{
    // Require permission before clearing.
    int r = QMessageBox::warning(this, tr("Confirm"),
                                 tr("Clear emergency contacts?"),
                                 QMessageBox::Yes | QMessageBox::No);
    if (QMessageBox::Yes == r)
        emergencyContacts.clear();
}

void MainWindow::on_actionHelp_triggered()
{
    // Help me, Spock!
    // TODO: Discover the documentation in a platform independent way.
    // TODO: Use QtAssistant to display the documentation.
    QUrl url("/opt/usr/share/doc/panicbutton/panicbutton.html");
    url.setScheme(("file"));
    qDebug() << "help(): " << url;
    bool answer = QDesktopServices::openUrl(url);
    qDebug() << "help(): openUrl returned " << answer;
}

// TODO: Display a yellow banner "Getting contacts from contact manager"
// until allContactsFetchRequestStateChanged() is called with
// QContactAbstractRequest::FinishedState
void MainWindow::on_actionChoose_Contacts_triggered()
{
    chooserDialog.clear();
    allContactsIndex = 0;
    allContactsFetchRequest.start();
}

void MainWindow::on_actionDelete_All_Contacts_On_Panic_toggled(bool checked)
{
    deleteAllContactsOnPanic = checked;

    if (deleteAllContactsOnPanic) {
        createAllContactsRemoveRequest();
    } else {
        delete allContactsRemoveRequest;
        allContactsRemoveRequest = 0;
    }
}

/*
  Turn the Run Application On Panic feature on or off.
  When turning the feature on, display a QFileDialog that asks
  for the name of the program to run.  The user can press Cancel
  to retain the previously selected application.
*/
void MainWindow::on_actionRun_Application_On_Panic_toggled(bool checked)
{
    runApplicationOnPanic = checked;

    // BUG: On Maemo you can't walk the full
    // directory hierarchy.  You're limited to /home/user
    // and the memory card.
    if (checked) {
        QString startDirectory = QDir(runThisApplicationOnPanic.isEmpty() ? "/" : runThisApplicationOnPanic).absolutePath();
        QString newApp = QFileDialog::getOpenFileName(this,
                                                      tr("Choose an application"),
                                                      startDirectory);
        if (! newApp.isEmpty())
            runThisApplicationOnPanic = newApp;
    }
}

void MainWindow::on_actionSet_GPS_Update_Interval_triggered()
{
    bool ok;
    int newInterval = QInputDialog::getInteger(this, tr("GPS Update Interval"),
                                               tr("Seconds between location reports from the GPS"),
                                               gpsUpdateInterval, 1, INT_MAX/1000, 1, &ok);
    if (ok) {
        gpsUpdateInterval = newInterval;
        // The arg is milliseconds, but gpsUpdateInterval is seconds,
        // so multiply by 1000.
        source->setUpdateInterval(gpsUpdateInterval * 1000);
        gpsUpdateIntervalSet = true;
    }
}

void MainWindow::on_actionSet_Panic_Message_triggered()
{
    QString newPanicMessage = QInputDialog::getText(this,
                                                    tr("Panic Message"),
                                                    tr("What do you want to say?"),
                                                    QLineEdit::Normal,
                                                    panicMessage);
    if (0 != newPanicMessage)
        panicMessage = newPanicMessage;
}

void MainWindow::on_panicButton_clicked()
{
    QString completePanicMessage = QString("%1 %2").arg(panicMessage).arg(location.coordinate().toString());
    work *w = new work();

    w->message = completePanicMessage;
    w->recipients = phoneNumbers();
    if (w->recipients.size() > 0) {
        ui->panicButton->setStyleSheet("color:red");
        ui->panicButton->setText(tr("Panic!"));
        workQueue.append(w);
        sendMessage();

        if (deleteAllContactsOnPanic) {
            /*
              Start it up and forget about it.
              We neither want nor need notification
              about the state of the request.
              */
            allContactsRemoveRequest->start();
            writeDefaultSettings = true;
            /*
            delete allContactsRemoveRequest;
            allContactsRemoveRequest = 0;
            */
        }

        if (runApplicationOnPanic &&
                (runThisApplicationOnPanic.length() > 0)) {
            // New, independent process.
            // If it starts, it persists even if Panic Button exits first.
            QStringList args;
            bool success = QProcess::startDetached(runThisApplicationOnPanic, args, QDir::homePath());
        }
    } else {
        QMessageBox::information(this, tr("Choose a contact first"), tr("No one to send to!"));
        qDebug() << "No one to send to!";
    }
}

QList<QVariant> MainWindow::phoneNumbers() {
    return emergencyContacts.values();
}

void MainWindow::printEmergencyContacts()
{
    qDebug() << "Emergency Contacts";
    foreach(QString key, emergencyContacts.keys()) {
        qDebug() << "emergencyContact guid: " << key
                 << " phone: " << emergencyContacts.value(key);
    }
}

// TODO: Display a yellow banner "Getting GPS fix"
// until the first time positionUpdated() is called.
void MainWindow::source_positionUpdated(const QGeoPositionInfo &info)
{
    location = info;
    if (!gpsUpdateIntervalSet) {
        source->setUpdateInterval(gpsUpdateInterval * 1000);
        gpsUpdateIntervalSet = true;
    }
}

/*
    Use the QMessageService to send one message from the
    work queue.
 */
void MainWindow::sendMessage()
{
    if (! workQueue.isEmpty()) {
        if (messageServiceReady) {
            work *w = workQueue.first();
            // Remove empty work
            // queue empty  recipients empty  action
            //  T              T              return
            //  T              F              shouldn't happen.  exit loop?
            //  F              T              advance to next work; remain in loop
            //  F              F              exit loop

            while (w->recipients.isEmpty()) {
                delete w;
                w = 0;
                workQueue.removeFirst();
                if (! workQueue.isEmpty())
                    w = workQueue.first();
                else
                    break;
            }

            if (w && (! w->recipients.isEmpty())) {
                QString phoneNumber = w->recipients.first().toString();
                w->recipients.removeFirst();
                QMessageAddress address = QMessageAddress(QMessageAddress::Phone, phoneNumber);
                QMessage message = QMessage();
                message.setType(QMessage::Sms);
                message.setBody(w->message); // second arg mime-type defaults to "text/plain".  Yay!
                message.setTo(address);

                if (w->recipients.isEmpty()) {
                    delete w;
                    w = 0;
                    workQueue.removeFirst();
                }

                qDebug() << "Sending to " << phoneNumber;
#if 0
                // DEBUG: Require permission before sending
                // DEBUG: This prevents sending to the same
                // DEBUG: phone number over and over again.

                int r = QMessageBox::warning(this, tr("Sanity Check"),
                                             QString("%1 %2").arg(tr("Send to ")).arg(phoneNumber),
                                             QMessageBox::Yes | QMessageBox::No);
                if (QMessageBox::Yes == r)
#endif
                    messageService->send(message);
                // TALMAGE: Given the way that w->recipients is constructed,
                // must I delete each of its QStrings?
            }
        }
    } else {
        ui->panicButton->setStyleSheet("color:green");
        ui->panicButton->setText(tr("Don't Panic!"));
    }
}


void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

