#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    readSettings();

    updateSliders();
    updateColorsIcons();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::readSettings()
{
    QSettings settings("packedmediawidget", "settings");

    gradientWidth = settings.value("gradientWidth", 40).toInt();

    if ( settings.contains("startingColor") )
    {
        QVariant variant;
        variant = settings.value("startingColor");
        startingColor = variant.value<QColor>();
    }
    else
    {
        startingColor = QColor( 0, 0, 0, 100);
    }

    if ( settings.contains("endingColor") )
    {
        QVariant variant;
        variant = settings.value("endingColor");
        endingColor = variant.value<QColor>();
    }
    else
    {
        endingColor = QColor( 0, 0, 0, 0);
    }

    startingColorAlphaValue = settings.value("startingColorAlphaValue", 100).toInt();
    endingColorAlphaValue = settings.value("endingColorAlphaValue", 0).toInt();

    buttonsHeight = settings.value("buttonsHeight", 83).toInt();


}

void SettingsDialog::updateColorsIcons()
{
    QPixmap pixmap(24, 24);
    pixmap.fill(startingColor);
    ui->changeStartingColorButton->setIcon(QIcon(pixmap));
    pixmap.fill(endingColor);
    ui->changeEndingColorButton->setIcon(QIcon(pixmap));
}

void SettingsDialog::on_changeStartingColorButton_clicked()
{
    startingColor = QColorDialog::getColor(startingColor, this, "Choose starting color");
    startingColorAlphaValue = ui->startingColorAlphaValueSpinBox->value();
    startingColor.setAlpha(startingColorAlphaValue);
    updateColorsIcons();
}

void SettingsDialog::on_changeEndingColorButton_clicked()
{
    endingColor = QColorDialog::getColor(endingColor, this, "Choose ending color");
    endingColorAlphaValue = ui->endingColorAlphaValueSpinBox->value();
    endingColor.setAlpha(endingColorAlphaValue);
    updateColorsIcons();
}

void SettingsDialog::updateSliders()
{
    ui->endingColorAlphaValueSlider->setValue(endingColorAlphaValue);
    ui->startingColorAlphaValueSlider->setValue(startingColorAlphaValue);
    ui->gradientWidthSlider->setValue(gradientWidth);
    ui->buttonsHeightSlider->setValue(buttonsHeight);
}

void SettingsDialog::on_saveButton_clicked()
{
    saveSettings();
    emit saveButtonClicked();
    close();
}

void SettingsDialog::saveSettings()
{
    QSettings settings("packedmediawidget", "settings");

    settings.setValue("gradientWidth", ui->gradientWidthSlider->value());
    settings.setValue("startingColor", startingColor);
    settings.setValue("endingColor", endingColor);
    settings.setValue("endingColorAlphaValue", ui->endingColorAlphaValueSlider->value());
    settings.setValue("startingColorAlphaValue", ui->startingColorAlphaValueSlider->value());
    settings.setValue("buttonsHeight", ui->buttonsHeightSlider->value());



}

void SettingsDialog::on_startingColorAlphaValueSlider_valueChanged(int value)
{
    startingColorAlphaValue = ui->startingColorAlphaValueSpinBox->value();
    startingColor.setAlpha(startingColorAlphaValue);
    updateColorsIcons();
}

void SettingsDialog::on_endingColorAlphaValueSlider_valueChanged(int value)
{
    endingColorAlphaValue = ui->endingColorAlphaValueSpinBox->value();
    endingColor.setAlpha(endingColorAlphaValue);
    updateColorsIcons();
}
