#ifndef RATEDIALOG_H
#define RATEDIALOG_H

/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dialog.h>

#include <Lum/Edit/Text.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>

#include "Configuration.h"

class RateDialog : public Lum::Dialog
{
private:
  Rating                &rating;

  Lum::Model::ActionRef commitAction;
  Lum::Edit::TextRef    comment;
  Lum::Model::SizeTRef  score;
  bool                  success;

public:
  RateDialog(Rating &rating);

  void PreInit();
  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);

  bool HasSuccess() const;
};

extern bool GetRate(Lum::Dialog *parent, Rating& rating);

#endif

