#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <list>
#include <set>
#include <string>

class Rating
{
public:
  std::wstring package;
  std::wstring version;
  int          score;
  std::wstring comment;
  bool         pushed;

  friend bool operator<(const Rating& r1, const Rating& r2);
  friend bool operator==(const Rating& r1, const Rating& r2);
};

extern bool operator<(const Rating& r1, const Rating& r2);
extern bool operator==(const Rating& r1, const Rating& r2);

extern std::set<Rating>  ratings;
extern bool              configurationChanged;
extern std::wstring      username;
extern std::wstring      password;
extern std::wstring      ossoVersion;

extern bool LoadConfig();
extern bool SaveConfig();

#endif
