# -*- coding: latin-1 -*-
#
#This file is part of Outlaw Solitaire.
#
#Copyright (c) 2010, Toni Knsl
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without 
#modification, are permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, 
#      this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, 
#      this list of conditions and the following disclaimer in the documentation 
#      and/or other materials provided with the distribution.
#    * The name of the authors may not be used to endorse or promote products 
#      derived from this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
#ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
#WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
#DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
#FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
#CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
#OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
import os, sys

BASEPATH = os.path.abspath(os.path.dirname(sys.argv[0]))

SCREENW = 800
SCREENH = 480

WINDOWEDSCREENW = SCREENW
WINDOWEDSCREENH = SCREENH - 56

#SHOWFPSCOUNTER = 1
SHOWFPSCOUNTER = 0

CARDW = 54
CARDH = 76
HALFCARDW=CARDW/2
HALFCARDH=CARDH/2

PLAYFIELDPADX = 24
PLAYFIELDPADY = 2
PLAYFIELDSIZEX = (CARDW*5) + (PLAYFIELDPADX*4)
PLAYFIELDSIZEY = (CARDH*5) + (PLAYFIELDPADY*4)
PLAYFIELDOFFSETX = (SCREENW-PLAYFIELDSIZEX) / 2
PLAYFIELDOFFSETY = (SCREENH-PLAYFIELDSIZEY) / 2

SHOEAREAW = (SCREENW - (PLAYFIELDOFFSETX + PLAYFIELDSIZEX))
SHOEPADY = PLAYFIELDPADY + 4
SHOESIZEX = CARDW
SHOEOFFSETX = PLAYFIELDOFFSETX + PLAYFIELDSIZEX + PLAYFIELDPADX
SHOEOFFSETY = PLAYFIELDOFFSETY - 2

DEALTCARDSPEED = 128
DEALTCARDSHADOWOFFSET = 4
DEALTCARDEVENTAREAW = 712
DEALTCARDEVENTAREAOFFSET = (46, 0)
DEALTCARDMOUSEDOWNGUARD = 10

GFXBASEDIR = os.path.join(BASEPATH, 'gfx')
BACKGROUNDGFXDIR = 'backgrounds'
DECKGFXDIR = 'decks'
DECKBACKGFXDIR = 'deck_backs'

FONTDIR = os.path.join(BASEPATH, 'font')
FONTCHARACTERSET = " ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!?$&()*\',;.:-"
SMALLFONTFILE = 'font_small.png'
SMALLWHITEFONTFILE  = 'font_small_white.png'
BIGFONTFILE = 'font_big.png'
BIGWHITEFONTFILE = 'font_big_white.png'
BIGREDFONTFILE = 'font_big_red.png'

LEFTMENUSLIDEX = 756
LEFTMENUSPEED = 256
LEFTMENUGFXDIR = 'left_menu'
LEFTMENUBACKGROUNDGFXFILE = 'background.png'
LEFTMENUBACKGROUNDSHADOWGFXFILE = 'background_shadow.png'
LEFTMENUBACKGROUNDSHADOWOFFSET = (796,0)
LEFTMENUNEWGAMEOFFSET = (91, 420)
LEFTMENUSLIDEOUTINACTIVEGFXFILE = 'slide_out_button_inactive.png'
LEFTMENUSLIDEOUTACTIVEGFXFILE = 'slide_out_button_active.png'
LEFTMENUSLIDEOUTOFFSET = (767, 240-19)
LEFTMENUSLIDEOUTEVENTAREA = (46, SCREENH)
LEFTMENUSLIDEININACTIVEGFXFILE = 'slide_in_button_inactive.png'
LEFTMENUSLIDEINACTIVEGFXFILE = 'slide_in_button_active.png'
LEFTMENUSLIDEINOFFSET = (10, 240-19)
LEFTMENUSLIDEINEVENTAREA = (46, SCREENH)

LEFTMENUWANTEDOFFSET = (65,23)
LEFTMENUTAPFORHISCORESGFXFILE = 'tap_for_hiscores.png'
LEFTMENUTAPFORPOINTSGFXFILE = 'tap_for_points.png'
LEFTMENUTAPFOROFFSET = (LEFTMENUWANTEDOFFSET[0]+104, LEFTMENUWANTEDOFFSET[1]+9)

LEFTMENUAMERICANTITLE = 'AMERICAN POINTS'
LEFTMENUAMERICANTITLEOFFSET = (LEFTMENUWANTEDOFFSET[0]+26, LEFTMENUWANTEDOFFSET[1]+20)
LEFTMENUENGLISHTITLE = 'ENGLISH POINTS'
LEFTMENUENGLISHTITLEOFFSET = (LEFTMENUWANTEDOFFSET[0]+26+18, LEFTMENUWANTEDOFFSET[1]+20)
LEFTMENUHANDNAMES = ('ROYAL FLUSH', 'STRAIGHT FLUSH', 'FOUR OF A KIND', 'FULL HOUSE', 'FLUSH', 'STRAIGHT', 'THREE OF A KIND', 'TWO PAIRS', 'ONE PAIR')
LEFTMENUHANDNAMESOFFSET = (LEFTMENUAMERICANTITLEOFFSET[0], LEFTMENUAMERICANTITLEOFFSET[1]+48)
LEFTMENUAMERICANPOINTS = ('100$', '75$', '50$', '25$', '20$', '15$', '10$', '5$', '2$')
LEFTMENUENGLISHPOINTS = ('30$', '30$', '16$', '10$', '5$', '12$', '6$', '3$', '1$')
LEFTMENUAMERICANPOINTSOFFSET = (LEFTMENUHANDNAMESOFFSET[0]+180+44, LEFTMENUHANDNAMESOFFSET[1])
LEFTMENUENGLISHPOINTSOFFSET = (LEFTMENUHANDNAMESOFFSET[0]+180+44+8, LEFTMENUHANDNAMESOFFSET[1])

LEFTMENUHIGHSCORETITLEOFFSET = (LEFTMENUWANTEDOFFSET[0]+51, LEFTMENUWANTEDOFFSET[1]+20)
LEFTMENUHIGHSCORENAMESOFFSET = (LEFTMENUWANTEDOFFSET[0]+26, LEFTMENUHIGHSCORETITLEOFFSET[1]+48)
LEFTMENUHIGHSCOREPOINTSOFFSET = (LEFTMENUHIGHSCORENAMESOFFSET[0]+121, LEFTMENUHIGHSCORENAMESOFFSET[1])
LEFTMENUHIGHSCOREDATESOFFSET = (LEFTMENUHIGHSCORENAMESOFFSET[0]+183, LEFTMENUHIGHSCORENAMESOFFSET[1])

LEFTMENUSETTINGSTITLEOFFSET = (506+4, 0+24)
LEFTMENUSETTINGSSUBTITLEOFFSET = (409+4, 41+24)
LEFTMENUCARDDECKTITLEOFFSET = (409+4, 82+24)
LEFTMENUCARD1OFFSET = (409+4, 82+32+24)
LEFTMENUCARD2OFFSET = (409+4+CARDW, 82+32+24)
LEFTMENUCARD3OFFSET = (409+4+CARDW+CARDW, 82+32+24)
LEFTMENUCARD4OFFSET = (409+4+CARDW+CARDW+CARDW, 82+32+24)
LEFTMENUDECKBACKOFFSET = (409+4+CARDW+CARDW+CARDW+CARDW+44, 82+32+24)
LEFTMENUBACKGROUNDTITLEOFFSET = (409+4, 197+5+24)
LEFTMENUBACKGROUNDOFFSET = (409+4, 197+32+5+24)
LEFTMENUPOINTSYSTEMTITLEOFFSET = (409+4, 305+2+24)
LEFTMENUPOINTSYSTEMOFFSET = (409+4, 305+32+2+24)
LEFTMENUAMERICANFLAGGFXFILE = 'american_flag.png'
LEFTMENUENGLISHFLAGGFXFILE = 'english_flag.png'

HANDNAMES      = 'royal flush','straight flush','four of a kind','straight','full house','three of a kind','flush','two pairs','pair','nothing'
AMERICANPOINTS =          100,              75,              50,        15,          25,               10,     20,          5,     2,        0
ENGLISHPOINTS  =           30,              30,              16,        12,          10,                6,      5,          3,     1,        0
AMERICANPOINTSDICT = dict(zip(HANDNAMES,AMERICANPOINTS))
ENGLISHPOINTSDICT = dict(zip(HANDNAMES,ENGLISHPOINTS))

RIGHTMENUGFXDIR = 'right_menu'
RIGHTMENUBACKGROUNDGFXFILE = 'background.png'
RIGHTMENUCLOSEINACTIVEGFXFILE = 'close_button_inactive.png'
RIGHTMENUCLOSEACTIVEGFXFILE = 'close_button_active.png'
RIGHTMENUCLOSEEVENTAREA = (42, 42)
RIGHTMENUCLOSEOFFSET = (765,7)
RIGHTMENUHELPINACTIVEGFXFILE = 'help_button_inactive.png'
RIGHTMENUHELPACTIVEGFXFILE = 'help_button_active.png'
RIGHTMENUHELPEVENTAREA = (42, 42)
RIGHTMENUHELPOFFSET = (773,111)
RIGHTMENUTOGGLEINACTIVEGFXFILE = 'toggle_button_inactive.png'
RIGHTMENUTOGGLEACTIVEGFXFILE = 'toggle_button_active.png'
RIGHTMENUTOGGLEEVENTAREA = (42, 42)
RIGHTMENUTOGGLEOFFSET = (763,224)

HIGHSCOREINPUTGFXDIR = 'high_score_input'
HIGHSCOREINPUTSILHOUETTEGFXFILE = 'silhouette.png'

SPLASHGFXDIR = 'splash'
SPLASHFILE = 'splash_256.png'
SPLASHNEWGAMEOFFSET = (151,404)
SPLASHCONTINUEGAMEOFFSET = (454,404)
