# -*- coding: latin-1 -*-
#
#This file is part of Outlaw Solitaire.
#
#Copyright (c) 2010, Toni Knsl
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without 
#modification, are permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, 
#      this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, 
#      this list of conditions and the following disclaimer in the documentation 
#      and/or other materials provided with the distribution.
#    * The name of the authors may not be used to endorse or promote products 
#      derived from this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
#ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
#WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
#DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
#FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
#CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
#OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
import os,pygame

def LoadGfx(path, file):
    temp_image = pygame.image.load(os.path.join(path, file)).convert()
    return temp_image

def LoadAlphaGfx(path, file):
    temp_image = pygame.image.load(os.path.join(path, file)).convert_alpha()
    return temp_image

def CreateSurface(size):
    temp_surface = pygame.Surface(size).convert()
    return temp_surface

def CreateAlphaSurface(size):
    temp_surface = pygame.Surface(size, pygame.SRCALPHA).convert_alpha()
    return temp_surface

def colorize_alpha_image(image, color):
    image.lock()
    for temp_y in range(0, image.get_height()):
        for temp_x in range(0, image.get_width()):
            temp_color = image.get_at((temp_x, temp_y))
            if temp_color[3] != 0:
                r, g, b = color
                a = temp_color[3]
                image.set_at((temp_x, temp_y), (r,g,b,a))
    image.unlock()

class GfxBank:
    gfxs = None
    gfx_key = None
    
    def __init__(self, path):
        self.gfxs = dict()
        
        for temp_file in os.listdir(path):
            if os.path.splitext(temp_file)[1] == '.png' or os.path.splitext(temp_file)[1] == '.jpg':
                self.gfxs[temp_file] = LoadGfx(path, temp_file)             

    def get_gfx_key(self):
        return self.gfx_key

    def get_gfx(self, gfx_key):
        self.gfx_key = gfx_key
        
        return self.gfxs[gfx_key]

    def get_first_gfx(self):
        temp_list = self.gfxs.keys()
        
        return self.get_gfx(temp_list[0])

    def get_next_gfx(self):
        temp_list = self.gfxs.keys()
        temp_index = temp_list.index(self.gfx_key)
        
        if temp_index + 1 < len(temp_list):
            return self.get_gfx(temp_list[temp_index+1])
        else:
            return None

    def get_prev_gfx(self):
        temp_list = self.gfxs.keys()
        temp_index = temp_list.index(self.gfx_key)
        
        if temp_index - 1 > -1:
            return self.get_gfx(temp_list[temp_index-1])
        else:
            return None

if __name__ == '__main__':
    pass
