#!/bin/sh

DIST=deb
SRC=..
rm ${DIST}/* -rv
mkdir -p ${DIST}/dists/testing/kimi/binary-armel
mkdir -p ${DIST}/dists/testing/kimi/binary-i386
mkdir -p  ${DIST}/dists/testing/kimi/source

cp ${SRC}/*.tar.gz ${SRC}/*.dsc ${DIST}/dists/testing/kimi/source

cp ${SRC}/*armel.deb ${DIST}/dists/testing/kimi/binary-armel
cp ${SRC}/*i386.deb ${DIST}/dists/testing/kimi/binary-i386

pushd .
cd ${DIST}

dpkg-scanpackages dists/testing/kimi/binary-armel /dev/null | gzip -9c > dists/testing/kimi/binary-armel/Packages.gz
dpkg-scanpackages dists/testing/kimi/binary-i386 /dev/null | gzip -9c > dists/testing/kimi/binary-i386/Packages.gz
dpkg-scansources dists/testing/kimi/source /dev/null | gzip -9c > dists/testing/kimi/source/Sources.gz

popd
echo rsync -avz ${DIST} kappa.cs.karelia.ru:public_html

