/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __MERGER_WINDOW_H__
#define __MERGER_WINDOW_H__

#include <hildon/hildon.h>

#include "merger.h"

G_BEGIN_DECLS

#define TYPE_MERGER_WINDOW            (merger_window_get_type ())
#define MERGER_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MERGER_WINDOW, MergerWindow))
#define MERGER_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MERGER_WINDOW, MergerWindowClass))
#define IS_MERGER_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MERGER_WINDOW))
#define IS_MERGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MERGER_WINDOW))
#define MERGER_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MERGER_WINDOW, MergerWindowClass))

typedef struct _MergerWindow        MergerWindow;
typedef struct _MergerWindowClass   MergerWindowClass;
typedef struct _MergerWindowPrivate MergerWindowPrivate;

struct _MergerWindowClass
{
    HildonStackableWindowClass parent_class;
};

struct _MergerWindow
{
    HildonStackableWindow parent;

    /*< private >*/
    MergerWindowPrivate *priv;
};

GType           merger_window_get_type  (void) G_GNUC_CONST;

GtkWidget*      merger_window_new       (OssoABookAggregator  *aggregator);

G_END_DECLS

#endif
