/*
 * This file is part of osso-abook-plugin-merge-contacts
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 * 
 * File with functions for working with account.
 */

#define GETTEXT_PACKAGE "gtk20"
#include <glib/gi18n-lib.h>

#include "accounts.h"
#include "appdata.h"

/**
 * Return glist with accounts user. 
 */
GList *get_enable_accounts() 
{
    GError *err = NULL;
    
    GList *result = NULL;
   
    gsize lenght = 0, i = 0; 
    GKeyFile *accounts_config;
    gchar *accounts_cfg_path;
    gchar **groups;
    GList *profiles = NULL;


    // Get config of user accounts.
    accounts_cfg_path = g_strjoin(NULL, g_get_home_dir(), 
		    "/.rtcom-accounts/accounts.cfg", NULL);
    accounts_config = g_key_file_new();
    if (!g_key_file_load_from_file(accounts_config, accounts_cfg_path, 
				    G_KEY_FILE_NONE, &err)) {
	g_warning("g_key_file_load_from_file() failed: %s\n", err->message);
	g_clear_error(&err);
	return result;
    }


    groups = g_key_file_get_groups(accounts_config, &lenght); 
    for (i = 0; i < lenght; i++) {
	gchar *profile_name, *profile_path, *service, *display_name, *default_account_domain;
	gchar **domains;
	GKeyFile *profile;
	Account *acc;

	// Get name of profile file from accounts.cfg user file.
	profile_name = g_key_file_get_value(accounts_config, groups[i], "Profile", &err);

	if (g_list_find_custom(profiles, profile_name, g_strcmp0)) {
	    g_free(profile_name);
	    continue;
	}

	profiles = g_list_append(profiles, profile_name);
	if (err) {
	    g_warning("g_key_file_load_from_file() failed: %s\n", err->message);
	    g_clear_error(&err);
	    continue;
	}

	// Get profile for service
	profile_path = g_strjoin(NULL, "/usr/share/osso-rtcom/", profile_name, ".profile", NULL);
	profile = g_key_file_new();
	if (!g_key_file_load_from_file(profile, profile_path, 
				    G_KEY_FILE_NONE, &err)) {
	    g_warning("g_key_file_load_from_file() failed: %s\n", err->message);
	    g_clear_error(&err);
	    continue;
	}


	// Get VCardField from profile group from file.
	service = g_key_file_get_value(profile, "Profile", "VCardField", NULL);
	if (!service) {
	    g_free(service);
	    continue;
	}
	
	acc = g_new0(Account, 1);
	acc->vcard_field_name = service;

	if (g_strcmp0(acc->vcard_field_name, "TEL")) {
	    acc->display_name = g_key_file_get_value(profile, "Profile", "DisplayName", NULL);
	} else {
	    acc->display_name = g_strdup("Cellular");
	}


	// For X-JABBER get field of DefaultAccountDomain
	default_account_domain = g_key_file_get_value(profile, "Profile", "DefaultAccountDomain", NULL);
	domains = g_strsplit_set(default_account_domain, ",", 0);

	if (domains) {
	    gint j = 0;
	    while (domains[j] != NULL) { 
		acc->domains = g_list_append (acc->domains, g_strstrip(domains[j]));
		j++;
	    }
	}

	// Add to result list
	result = g_list_append(result, acc);

	g_key_file_free(profile);
	g_free(default_account_domain);
	g_free(profile_path);
    }
  
    g_list_free(profiles); 
    g_strfreev(groups);
    g_key_file_free(accounts_config);
    g_free(accounts_cfg_path);

    return result;
}


