#!/usr/bin/perl
# Convert an elemstyles.xml template which assumes white background and 100%
# opacity to an elemstyles.xml which fitted to a different background and
# opacity. The colours are supposed to stay roughly the same, albeit with some
# clamping distortion.

use strict;
use warnings FATAL => qw{all};

# XXX: TEMPORARY HACK TO MAKE IT COMPILE ON MY DESKTOP // AMDmi3
exit 0;

our $OPACITY = shift(@ARGV);
our $BG_COL = shift(@ARGV);
defined($OPACITY) && defined($BG_COL)
  or die "usage: $0 OPACITY BGCOL [FILES...]\n";

sub parse_col {
    my $rgbstr = shift;
    my $xx = '[a-fA-F0-9]{2}';
    if ($rgbstr =~ m/\A\#($xx)($xx)($xx)\z/) {
        return (hex($1), hex($2), hex($3));
    }
    elsif ($rgbstr =~ m/^__.*__$/) {
        return ();
    }
    die "$ARGV:$.: RGB string \"$rgbstr\" is misformatted";
}

sub fmt_col {
    return sprintf("#%02x%02x%02x", @_);
}

sub component_fix {
    my ($bg_c, $want_c) = (@_);
    my $targ_c = ($want_c - ($OPACITY * $bg_c)) / (1 - $OPACITY);
    if ($targ_c > 0xff) {
        warn "Want $want_c, but target $targ_c > 0xff. Clamping.\n";
        $targ_c = 0xff;
    }
    if ($targ_c < 0) {
        warn "Want $want_c, but target $targ_c < 0. Clamping.\n";
        $targ_c = 0;
    }
    return $targ_c;
}

my ($br, $bg, $bb) = parse_col($BG_COL);
my $now = localtime(time);
while (my $line = <>) {
    $line =~ s{__TEMPLATE__}{
***
*** This file was automatically generated from $ARGV
*** at $now by $0.
***
*** Do not edit this file if you want your ganges to persist! Edit the
*** template and run $0 again to generate it instead.
***
}g;
    $line =~ s{<(\s*area\b[^<>]*)/\s*>}{
        my $area = $1;
        $area =~ s!\bcolour\s*=\s*"([^"]*)"!
            my $r_col = $1;
            my ($rr, $rg, $rb) = parse_col($r_col);
            if (defined $rr) {
                my $tr = component_fix($br, $rr);
                my $tg = component_fix($bg, $rg);
                my $tb = component_fix($bb, $rb);
                my $t_col = fmt_col($tr, $tg, $tb);
                "colour=\"$t_col\"";
            }
            else {
                "colour=\"$r_col\"";  # unchanged
            }
        !ge;
        "<$area/>";
    }ge;
    $line =~ s{__BG_COL__}{$BG_COL}g;
    print $line;
}
continue {
    close ARGV if eof;  # reset $.
}

