//
// orefilenameform.h
//
// Implementation of the file name dialog for Orecchiette.
//
// Copyright 2014 by John Pietrzak (jpietrzak8@gmail.com)
//
// This file is part of Orecchiette.
//
// Orecchiette is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Orecchiette is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Orecchiette; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#ifndef OREFILENAMEFORM_H
#define OREFILENAMEFORM_H

#include <QDialog>

namespace Ui {
class OreFileNameForm;
}


class OreFileNameForm: public QDialog
{
  Q_OBJECT

public:
  OreFileNameForm(
    QWidget *parent,
    QString &format);

  ~OreFileNameForm();

private slots:
  void on_formatSpecifierComboBox_activated(
    const QString & text);

  void on_pushButtonValidate_clicked();
  void on_pushButtonOK_clicked();

private:
  QString &fileNameFormat;
  Ui::OreFileNameForm *ui;
};

#endif // OREFILENAMEFORM_H
