;NSIS OpenXcom Windows Installer Language

;================ENGLISH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_ENGLISH} "${GAME_NAME} requires a copy of UFO: Enemy Unknown / X-COM: UFO Defense. You can skip this step if you're upgrading an existing installation.$\n$\nSetup will copy the required files from the following folder. To copy from a different folder, click Browse and select another folder. Click Next to continue."
LangString PAGE_UfoFolder_TITLE ${LANG_ENGLISH} "Choose X-COM 1 Location"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_ENGLISH} "Choose the folder where you have X-COM 1 installed."
LangString DEST_UfoFolder ${LANG_ENGLISH} "X-COM 1 Folder"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_ENGLISH} "Game Files"
LangString DESC_SecMain ${LANG_ENGLISH} "Files required to run ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_ENGLISH} "Data Patch"
LangString DESC_SecPatch ${LANG_ENGLISH} "Fixes errors in the X-COM 1 data. Recommended for first installations. (requires an internet connection)"
LangString NAME_SecPortable ${LANG_ENGLISH} "Portable Installation"
LangString DESC_SecPortable ${LANG_ENGLISH} "Puts all ${GAME_NAME} files in the same folder, making a portable installation."
LangString NAME_SecSteam ${LANG_ENGLISH} "Launch from Steam"
LangString DESC_SecSteam ${LANG_ENGLISH} "Replaces your Steam X-COM 1 installation with ${GAME_NAME}. Uninstall restores it."
LangString NAME_SecDesktop ${LANG_ENGLISH} "Desktop Shortcut"
LangString DESC_SecDesktop ${LANG_ENGLISH} "Creates a shortcut in the desktop to play ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_ENGLISH} "Delete X-COM Data"
LangString DESC_UnData ${LANG_ENGLISH} "Deletes all ${GAME_NAME} data, including mods and X-COM resources. Recommended for a clean reinstall."
LangString NAME_UnUser ${LANG_ENGLISH} "Delete User Data"
LangString DESC_UnUser ${LANG_ENGLISH} "Deletes all ${GAME_NAME} user data, including savegames, screenshots and options. Recommended for a complete wipe."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_ENGLISH} "Data Folder"
LangString LINK_Readme ${LANG_ENGLISH} "Readme"
LangString LINK_UserFolder ${LANG_ENGLISH} "User Folder"
LangString LINK_Uninstall ${LANG_ENGLISH} "Uninstall"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_ENGLISH} "X-COM 1 wasn't found in this folder. ${GAME_NAME} requires a valid installation of X-COM to run. Continue?"
LangString WARN_XCUDetected ${LANG_ENGLISH} "XcomUtil detected. ${GAME_NAME} is incompatible with XcomUtil and may experience weird behavior. Continue?"

;================HUNGARIAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_HUNGARIAN} "Az ${GAME_NAME}nak szüksége van az UFO: Enemy Unknown / X-COM: UFO Defense egy másolatára. Ha egy meglévő telepítést frissítesz, akkor ez a lépés kihagyható.$\n$\nA telepítő az alábbi mappából fogja bemásolni a szükséges fájlokat. Más mappából való másoláshoz kattints a Tallóz gombra és válassz mappát. A folytatáshoz kattints a Tovább gombra."
LangString PAGE_UfoFolder_TITLE ${LANG_HUNGARIAN} "Válaszd ki az X-COM 1 helyét"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_HUNGARIAN} "Válaszd ki a mappát, ahová az X-COM 1 telepítve van."
LangString DEST_UfoFolder ${LANG_HUNGARIAN} "X-COM 1 Mappa"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_HUNGARIAN} "Játék fájljai"
LangString DESC_SecMain ${LANG_HUNGARIAN} "Az ${GAME_NAME} futtatásához szükséges fájlok."
LangString NAME_SecPatch ${LANG_HUNGARIAN} "Adatok javítása"
LangString DESC_SecPatch ${LANG_HUNGARIAN} "Az X-COM 1 adatfájljainak hibáit javítja. Első telepítéshez javasolt. (Internetkapcsolatot igényel)"
LangString NAME_SecDesktop ${LANG_HUNGARIAN} "Asztali Parancsikon"
LangString DESC_SecDesktop ${LANG_HUNGARIAN} "Parancsikont hoz létre az asztalon az ${GAME_NAME} indításához."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_HUNGARIAN} "X-COM adatfájlok törlése"
LangString DESC_UnData ${LANG_HUNGARIAN} "Töröl minden ${GAME_NAME} adatot, beleértve a modokat és az X-COM fájlokat. Tiszta újratelepítéshez javasolt."
LangString NAME_UnUser ${LANG_HUNGARIAN} "Felhasználói adatok törlése"
LangString DESC_UnUser ${LANG_HUNGARIAN} "Töröl minden ${GAME_NAME} felhasználói adatot, beleértve a játékmentéseket, mentett képernyőképeket és beállításokat. Teljes törléshez javasolt."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_HUNGARIAN} "Adat Mappa"
LangString LINK_Readme ${LANG_HUNGARIAN} "Olvass el"
LangString LINK_UserFolder ${LANG_HUNGARIAN} "Felhasználó Mappája"
LangString LINK_Uninstall ${LANG_HUNGARIAN} "Eltávolítás"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_HUNGARIAN} "Ebben a mappában X-COM 1 nem található. Az ${GAME_NAME}nak szüksége van egy telepített X-COM példányra a futtatáshoz. Folytatod?"
LangString WARN_XCUDetected ${LANG_HUNGARIAN} "XcomUtil észlelve. Az ${GAME_NAME} nem kompatibilis az XcomUtillal és emiatt furcsa viselkedést tapasztalhatsz. Folytatod?"

;================ROMANIAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_ROMANIAN} "${GAME_NAME} necesită o copie a UFO: Enemy Unknown / X-COM: UFO Defense. Dacă se face o actualizare a unei instalări existente se poate trece peste acest pas.$\n$\nInstalarea va copia fișierele necesare din următorul dosar. Pentru a copia din alt dosar, apăsați pe Alege și selectați altă locație. Apăsați pe Înainte pentru a continua."
LangString PAGE_UfoFolder_TITLE ${LANG_ROMANIAN} "Locația X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_ROMANIAN} "Alegeți dosarul unde este instalat X-COM 1."
LangString DEST_UfoFolder ${LANG_ROMANIAN} "Dosarul X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_ROMANIAN} "Fișierele Jocului"
LangString DESC_SecMain ${LANG_ROMANIAN} "Fișierele necesare pentru a rula ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_ROMANIAN} "Actualizare Date"
LangString DESC_SecPatch ${LANG_ROMANIAN} "Repară unele erori din datele X-COM 1. Recomandat pentru primele instalări. (necesită o conexiune la internet)"
LangString NAME_SecPortable ${LANG_ROMANIAN} "Instalare Portabilă"
LangString DESC_SecPortable ${LANG_ROMANIAN} "Pune toate fișierele ${GAME_NAME} în același dosar, realizând o instalare portabilă."
LangString NAME_SecSteam ${LANG_ROMANIAN} "Lansare din Steam"
LangString DESC_SecSteam ${LANG_ROMANIAN} "Înlocuiește instalarea X-COM 1 din Steam cu ${GAME_NAME}. Dezinstalarea o va restaura."
LangString NAME_SecDesktop ${LANG_ROMANIAN} "Scurtătură Desktop"
LangString DESC_SecDesktop ${LANG_ROMANIAN} "Crează o scurtătură pe ecran pentru a juca ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_ROMANIAN} "Ștergere Date X-COM"
LangString DESC_UnData ${LANG_ROMANIAN} "Șterge toate datele ${GAME_NAME}, inclusiv modificările și resursele X-COM. Recomandat pentru o reinstalare curată."
LangString NAME_UnUser ${LANG_ROMANIAN} "Ștergere Date Utilizator"
LangString DESC_UnUser ${LANG_ROMANIAN} "Șterge toate datele de utilizator pentru ${GAME_NAME}, inclusiv salvările, capturile de ecran și opțiunile. Recomandat pentru o ștergere completă."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_ROMANIAN} "Dosar Date"
LangString LINK_Readme ${LANG_ROMANIAN} "Citește"
LangString LINK_UserFolder ${LANG_ROMANIAN} "Dosar Utilizator"
LangString LINK_Uninstall ${LANG_ROMANIAN} "Dezinstalare"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_ROMANIAN} "X-COM 1 nu s-a găsit în acest dosar. ${GAME_NAME} necesită o instalare X-COM validă pentru a rula. Continuați?"
LangString WARN_XCUDetected ${LANG_ROMANIAN} "XcomUtil detectat. ${GAME_NAME} este incompatibil cu XcomUtil și poate duce la un comportament ciudat. Continuați?"

;================POLISH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_POLISH} "${GAME_NAME} wymaga kopii gry UFO: Enemy Unknown na dysku. Możesz pominąć ten krok, jeśli aktualizujesz już istniejącą instalację.$\n$\nInstalator skopiuje potrzebne pliki z poniższego folderu. Aby zmienić folder źródłowy, naciśnij przycisk Przeglądaj i wybierz inny folder. Naciśnij Dalej, aby kontynuować."
LangString PAGE_UfoFolder_TITLE ${LANG_POLISH} "Wskaż lokalizację gry UFO: Enemy Unknown"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_POLISH} "Wybierz folder, w którym zainstalowana jest gra UFO: Enemy Unknown."
LangString DEST_UfoFolder ${LANG_POLISH} "Folder UFO: Enemy Unknown"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_POLISH} "Pliki gry"
LangString DESC_SecMain ${LANG_POLISH} "Pliki potrzebne do uruchomienia gry ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_POLISH} "Łatka aktualizacyjna"
LangString DESC_SecPatch ${LANG_POLISH} "Naprawia błędy danych w UFO: Enemy Unknown. Zalecane przy pierwszej instalacji (wymaga połączenia z internetem)."
LangString NAME_SecPortable ${LANG_POLISH} "Instalacja przenośna"
LangString DESC_SecPortable ${LANG_POLISSH} "Umieszcza wszystkie pliki ${GAME_NAME} w tym samym folderze, tworząc przenośną instalację."
LangString NAME_SecSteam ${LANG_POLISSH} "Uruchamiaj z menu Steam"
LangString DESC_SecSteam ${LANG_POLISSH} "Zastępuje instalację UFO: Enemy Unknown na Steam przez ${GAME_NAME}. Deinstalacja przywraca poprzednie ustawienia."
LangString NAME_SecDesktop ${LANG_POLISH} "Skrót na pulpicie"
LangString DESC_SecDesktop ${LANG_POLISH} "Tworzy na pulpicie skrót do gry ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_POLISH} "Usuń pliki gry UFO: Enemy Unknown"
LangString DESC_UnData ${LANG_POLISH} "Usuń wszystkie dane gry ${GAME_NAME}, włącznie z modami i plikami gry UFO: Enemy Unknown. Zalecane dla czystej reinstalacji."
LangString NAME_UnUser ${LANG_POLISH} "Usuń dane użytkownika"
LangString DESC_UnUser ${LANG_POLISH} "Usuwa wszystkie dane użytkownika gry ${GAME_NAME}, łącznie z zapisanymi stanami gry, zrzutami ekranu i ustawieniami. Zalecane dla całkowitego usunięcia programu."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_POLISH} "Folder danych"
LangString LINK_Readme ${LANG_POLISH} "Informacje"
LangString LINK_UserFolder ${LANG_POLISH} "Folder użytkownika"
LangString LINK_Uninstall ${LANG_POLISH} "Odinstaluj"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_POLISH} "Nie znaleziono gry UFO: Enemy Unknown w tym folderze. Do właściwego działania, ${GAME_NAME} wymaga prawidłowo zainstalowanej gry UFO: Enemy Unknown. Kontynuować?"
LangString WARN_XCUDetected ${LANG_POLISH} "Wykryto modyfikację XcomUtil. Gra ${GAME_NAME} nie jest kompatybilna z programem XcomUtil, który może spowodować niewłaściwe jej działanie. Kontynuować?"

;================GERMAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_GERMAN} "${GAME_NAME} benötigt das original von UFO: Enemy Unknown / XCOM: UFO Defense. Dieser Schritt kann überprungen werden, wenn eine bestehende Installation vorhanden ist. $\n$\nDas Setup wird die benötigten Dateien aus dem folgenden Ordner kopieren. Um aus einem anderen Ordner zu kopieren, klicke auf durchsuchen und wähle einen anderen Ordner. Klicke auf Weiter, um fortzusetzen. "
LangString PAGE_UfoFolder_TITLE ${LANG_GERMAN} "Wähle X-COM 1 Installationspfad."
LangString PAGE_UfoFolder_SUBTITLE ${LANG_GERMAN} "Wähle den Ordner, wo XCOM 1 installiert ist."
LangString DEST_UfoFolder ${LANG_GERMAN} "X-COM 1 Ordner"

;--------------------------------
;Installer Sections
   
LangString NAME_SecMain ${LANG_GERMAN} "Spieldateien"
LangString DESC_SecMain ${LANG_GERMAN} "Dateien, die zum Betrieb erforderlich sind ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_GERMAN} "Datei-Patch"
LangString DESC_SecPatch ${LANG_GERMAN} "Repariert Fehler in Dateien von XCOM 1. Wird für die erste Installation empfohlen. (Benötigt eine Verbidung zum Internet.)"
LangString NAME_SecPortable ${LANG_GERMAN} "Portable Installation"
LangString DESC_SecPortable ${LANG_GERMAN} "Entpackt alle ${GAME_NAME} Datein in das selbe Verzeichnis, für eine portable installation."
LangString NAME_SecSteam ${LANG_GERMAN} "Von Steam starten"
LangString DESC_SecSteam ${LANG_GERMAN} "Ersetzt deine Steam X-COM 1 installation mit ${GAME_NAME}. Uninstall wiederherstellen."
LangString NAME_SecDesktop ${LANG_GERMAN} "Verknüpfung auf dem Desktop"
LangString DESC_SecDesktop ${LANG_GERMAN} "Stellt eine Verknüpfung auf dem Desktop her, um  ${GAME_NAME} spielen zu können."
   
;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_GERMAN} "Lösche die Daten von XCOM."
LangString DESC_UnData ${LANG_GERMAN} "Löscht alle ${GAME_NAME} Dateien, inklusive aller MODs und XCOM Dateien. Empfehlenswert im Falle einer fehlerfreien Neuinstallation."
LangString NAME_UnUser ${LANG_GERMAN} "Lösche Benutzerdaten"
LangString DESC_UnUser ${LANG_GERMAN} "Löscht alle ${GAME_NAME} Benutzerdaten, einschließlich Spielstände, Bildschirmbilder und Optionen. Empfohlen für ein vollständiges Löschen."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_GERMAN} "Dateien-Verzeichnis"
LangString LINK_Readme ${LANG_GERMAN} "Readme"
LangString LINK_UserFolder ${LANG_GERMAN} "Benutzer-Verzeichnis"
LangString LINK_Uninstall ${LANG_GERMAN} "Deinstallation"
   
;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_GERMAN} "X-COM 1 wurde in diesem Ordner nicht gefunden. ${GAME_NAME} benötigt einer gültigen Installation von XCOM. Fortsetzen?"
LangString WARN_XCUDetected ${LANG_GERMAN} "XcomUtil wurde entdeckt. ${GAME_NAME} ist nicht mit XcomUtil kompatibel und kann zu unvorhersagbaren Fehlern führen. Fortsetzen?"

;================BRAZILIAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_PORTUGUESEBR} "${GAME_NAME} requer uma cópia de UFO: Enemy Unknown / X-COM: UFO Defense. Você pode pular este passo se estiver atualizando uma instalação existente.$\n$\nO instalador copiará os arquivos necessários da seguinte pasta. Para copiar de uma pasta diferente, clique em Navegar e selecione outra pasta. Clique em Próximo para continuar."
LangString PAGE_UfoFolder_TITLE ${LANG_PORTUGUESEBR} "Selecione a localização do X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_PORTUGUESEBR} "Escolha a pasta onde o X-COM 1 foi instalado."
LangString DEST_UfoFolder ${LANG_PORTUGUESEBR} "Pasta do X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_PORTUGUESEBR} "Arquivos do Jogo"
LangString DESC_SecMain ${LANG_PORTUGUESEBR} "Arquivos necessários para executar ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_PORTUGUESEBR} "Correção dos Dados"
LangString DESC_SecPatch ${LANG_PORTUGUESEBR} "Corrige erros nos dados do X-COM 1. Recomendado nas primeiras instalações. (requer uma conexão com a internet)"
LangString NAME_SecDesktop ${LANG_PORTUGUESEBR} "Atalho na Área de Trabalho"
LangString DESC_SecDesktop ${LANG_PORTUGUESEBR} "Cria um atalho na área de trabalho para jogar ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_PORTUGUESEBR} "Apagar Dados do X-COM"
LangString DESC_UnData ${LANG_PORTUGUESEBR} "Remove todos os arquivos do ${GAME_NAME}, incluindo mod e recursos do X-COM. Recomendado para um reinstalação limpa."
LangString NAME_UnUser ${LANG_PORTUGUESEBR} "Apagar Dados do Usuário"
LangString DESC_UnUser ${LANG_PORTUGUESEBR} "Remove todos os dados dos usuários do ${GAME_NAME}, incluindo jogos salvos, capturas de tela e opções. Recommendado para uma limpeza completa."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_PORTUGUESEBR} "Pasta de Dados"
LangString LINK_Readme ${LANG_PORTUGUESEBR} "Leiame"
LangString LINK_UserFolder ${LANG_PORTUGUESEBR} "Pasta de Usuário"
LangString LINK_Uninstall ${LANG_PORTUGUESEBR} "Desinstalar"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_PORTUGUESEBR} "X-COM 1 não foi encontrado nesta pasta. ${GAME_NAME} requer uma instalação válida do X-COM para executar. Continuar?"
LangString WARN_XCUDetected ${LANG_PORTUGUESEBR} "XcomUtil detectado. ${GAME_NAME} é incompatível com XcomUtil e pode apresentar comportamentos estranhos. Continuar?"

;================RUSSIAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_RUSSIAN} "Для ${GAME_NAME} требуется копия UFO: Enemy Unknown / X-COM: UFO Defense. Вы можете пропустить этот шаг, если выполняется обновление существующей установки.$\n$\nУстановка скопирует необходимые файлы из следующего каталога. Чтобы выбрать другой каталог, нажмите Просмотр и выберите другой каталог. Нажмите Далее для продолжения."
LangString PAGE_UfoFolder_TITLE ${LANG_RUSSIAN} "Укажите расположение X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_RUSSIAN} "Укажите каталог, в котором установлен X-COM 1."
LangString DEST_UfoFolder ${LANG_RUSSIAN} "Каталог X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_RUSSIAN} "Файлы игры"
LangString DESC_SecMain ${LANG_RUSSIAN} "Файлы, необходимые для запуска ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_RUSSIAN} "Исправление данных"
LangString DESC_SecPatch ${LANG_RUSSIAN} "Исправляет ошибки в данных X-COM 1. Рекомедуется для первоначальной установки (требуется подключение к Интернету)."
LangString NAME_SecPortable ${LANG_RUSSIAN} "Портативная (Portable) установка"
LangString DESC_SecPortable ${LANG_RUSSIAN} "Помещает все файлы ${GAME_NAME} в одну папку, создавая портативную установку."
LangString NAME_SecSteam ${LANG_RUSSIAN} "Запускать из клиента Steam"
LangString DESC_SecSteam ${LANG_RUSSIAN} "Заменяет Вашу версию X-COM 1 в клиенте Steam на ${GAME_NAME}. Удаление их восстанавливает."
LangString NAME_SecDesktop ${LANG_RUSSIAN} "Создать ярлык на Рабочем столе"
LangString DESC_SecDesktop ${LANG_RUSSIAN} "Создает ярлык для ${GAME_NAME} на Рабочем столе."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_RUSSIAN} "Удалить данные X-COM"
LangString DESC_UnData ${LANG_RUSSIAN} "Удаляет все данные ${GAME_NAME}, включая модификации и ресурсы X-COM. Рекомендуется для полной переустановки."
LangString NAME_UnUser ${LANG_RUSSIAN} "Удалить пользовательские данные"
LangString DESC_UnUser ${LANG_RUSSIAN} "Удаляет все пользовательские данные ${GAME_NAME}, включая сохранения, снимки экрана и настройки. Рекомендуется для полной очистки."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_RUSSIAN} "Каталог с данными"
LangString LINK_Readme ${LANG_RUSSIAN} "Readme"
LangString LINK_UserFolder ${LANG_RUSSIAN} "Пользовательский каталог"
LangString LINK_Uninstall ${LANG_RUSSIAN} "Удаление"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_RUSSIAN} "В данном каталоге X-COM 1 не найден. Для запуска ${GAME_NAME} требуется установленный X-COM. Продолжить?"
LangString WARN_XCUDetected ${LANG_RUSSIAN} "Обнаружен XcomUtil. ${GAME_NAME} несовместим с XcomUtil, что может вызвать непредвиденные последствия. Продолжить?"

;================TURKISH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_TURKISH} "${GAME_NAME} çalıştırabilmek için bir UFO: Enemy Unknown / X-COM: UFO Defense kopyası gereklidir. Eğer mevcut bir kurulumu güncelliyorsanız bu adımı atlayabilirsiniz.$\n$\nKurulum, gerekli dosyaları bu dizinden kopyalayacaktır. Farklı bir dizinden kopyalamak için Gözat butonuna basın ve doğru dizini seçin. Devam etmek için Sonraki butonuna basın."
LangString PAGE_UfoFolder_TITLE ${LANG_TURKISH} "X-COM 1 Konumunu Seç"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_TURKISH} "X-COM 1'in kurulu olduğu dizini seçin"
LangString DEST_UfoFolder ${LANG_TURKISH} "X-COM 1 Dizini"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_TURKISH} "Oyun Dosyaları"
LangString DESC_SecMain ${LANG_TURKISH} "${GAME_NAME}'i çalıştırmak için gerekli dosyalar."
LangString NAME_SecPatch ${LANG_TURKISH} "Veri Yaması"
LangString DESC_SecPatch ${LANG_TURKISH} "X-COM 1 verilerindeki hataları düzeltir. İlk kurulumda yapılması tavsiye edilir. (Internet bağlantısı gereklidir)"
LangString NAME_SecPortable ${LANG_TURKISH} "Taşınabilir Kurulum"
LangString DESC_SecPortable ${LANG_TURKISH} "Tüm ${GAME_NAME} dosyalarını aynı dizine kopyalayarak taşınabilir bir kurulum oluşturur."
LangString NAME_SecSteam ${LANG_TURKISH} "Steam üzerinden Başlat"
LangString DESC_SecSteam ${LANG_TURKISH} "Steam üzerindeki X-COM 1 kurulumunuzu ${GAME_NAME} kullanacak hale getirir. Program kaldırma ile değişiklikleri geri alabilirsiniz."
LangString NAME_SecDesktop ${LANG_TURKISH} "Masaüstü Kısayolu"
LangString DESC_SecDesktop ${LANG_TURKISH} "Masaüstünde, ${GAME_NAME} için bir kısayol oluşturur."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_TURKISH} "X-COM Verilerini Sil"
LangString DESC_UnData ${LANG_TURKISH} "Modlar ve X-COM kaynakları da dahil olmak üzere tüm ${GAME_NAME} verileri silinir. Temiz bir kurulum için tavsiye edilir."
LangString NAME_UnUser ${LANG_TURKISH} "Kullanıcı Verilerini Sil"
LangString DESC_UnUser ${LANG_TURKISH} "Kayıtlı oyunlar, ekran görüntüleri ve seçenekler dahil olmak üzere tüm ${GAME_NAME} kullanıcı verileri silinir. Tam bir temizlik için tavsiye edilir."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_TURKISH} "Veri Dizini"
LangString LINK_Readme ${LANG_TURKISH} "Okubeni"
LangString LINK_UserFolder ${LANG_TURKISH} "Kullanıcı Dizini"
LangString LINK_Uninstall ${LANG_TURKISH} "Program Kaldır"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_TURKISH} "X-COM 1 bu dizinde bulunamadı. ${GAME_NAME} için geçerli bir X-COM kurulumu zorunludur. Devam?"
LangString WARN_XCUDetected ${LANG_TURKISH} "XcomUtil tespit edildi. ${GAME_NAME} XcomUtil ile uyumlu olmadığından tuhaf sorunlarla karşılabilirsiniz. Devam?"

;================SPANISH INTERNATIONAL================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_SPANISHINTERNATIONAL} "${GAME_NAME} requiere una copia de UFO: Enemy Unknown / X-COM: UFO Defense. Puede omitir este paso si va a actualizar una instalación existente.$\n$\nEl programa de instalación copiará los archivos necesarios en la siguiente carpeta. Para copiar desde una carpeta diferente, presione en Explorar y seleccione otra carpeta. Precione en Siguiente para continuar."
LangString PAGE_UfoFolder_TITLE ${LANG_SPANISHINTERNATIONAL} "Selecione ubicación X-COM 1 "
LangString PAGE_UfoFolder_SUBTITLE ${LANG_SPANISHINTERNATIONAL} "Selecione la carpeta donde tiene X-COM 1 instalado."
LangString DEST_UfoFolder ${LANG_SPANISHINTERNATIONAL} "X-COM 1 carpeta"
;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_SPANISHINTERNATIONAL} "Archivos del juego"
LangString DESC_SecMain ${LANG_SPANISHINTERNATIONAL} "Archivos necesarios para ejecutar ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_SPANISHINTERNATIONAL} "Parche de datos"
LangString DESC_SecPatch ${LANG_SPANISHINTERNATIONAL} "Corrige los errores en los datos de X-COM 1. Recomendado para instalaciones iniciales. (requiere una conexión al Internet)"
LangString NAME_SecDesktop ${LANG_SPANISHINTERNATIONAL} "Atajo en el escritorio"
LangString DESC_SecDesktop ${LANG_SPANISHINTERNATIONAL} "Crea un acceso directo en el escritorio para jugar ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions
LangString NAME_UnData ${LANG_SPANISHINTERNATIONAL} "Borra datos de X-COM"
LangString DESC_UnData ${LANG_SPANISHINTERNATIONAL} "Borra todos los datos de ${GAME_NAME}, incluyendo mods y los recursos de X-COM. Recomendado para una reinstalación limpia."
LangString NAME_UnUser ${LANG_SPANISHINTERNATIONAL} "Borra datos de usuario"
LangString DESC_UnUser ${LANG_SPANISHINTERNATIONAL} "Borra todos los datos del usuario ${GAME_NAME}, incluyendo partidas guardadas, capturas de pantalla y opciones. Recomendado para una limpieza completa. "
;--------------------------------
;Shortcuts
LangString LINK_DataFolder ${LANG_SPANISHINTERNATIONAL} "Carpeta de datos"
LangString LINK_Readme ${LANG_SPANISHINTERNATIONAL} "Leerme"
LangString LINK_UserFolder ${LANG_SPANISHINTERNATIONAL} "Carpeta de usuario"
LangString LINK_Uninstall ${LANG_SPANISHINTERNATIONAL} "Desinstalación"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_SPANISHINTERNATIONAL} "X-COM 1 no se encuentra en esta carpeta. ${GAME_NAME} requiere una instalación válida de X-COM para ejecutarse. ¿Desea continuar?"
LangString WARN_XCUDetected ${LANG_SPANISHINTERNATIONAL} "XcomUtil detectado. ${GAME_NAME} es incompatible con XcomUtil y puede experimentar un comportamiento extraño. ¿Desea continuar?"

;================FRENCH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_FRENCH} "${GAME_NAME} nécessite UFO: Enemy Unknown / X-COM: UFO Defense. Vous pouvez passer cette étape si vous modifiez une installation existante.$\n$\n Le programme d'installation va transférer les fichiers nécessaires depuis le dossier suivant.  Pour transférer les fichiers depuis un autre dossier,  cliquez « Parcourir » et sélectionnez un autre dossier puis cliquez « suivant » pour continuer."
LangString PAGE_UfoFolder_TITLE ${LANG_FRENCH} "Choisissez le répertoire d'installation pour X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_FRENCH} "Choisissez le répertoire où est installé X-COM 1."
LangString DEST_UfoFolder ${LANG_FRENCH} "Répertoire X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_FRENCH} "Fichiers du jeu"
LangString DESC_SecMain ${LANG_FRENCH} "Fichiers nécessaires pour exécuter ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_FRENCH} "Données du Patch"
LangString DESC_SecPatch ${LANG_FRENCH} "Corrige les problèmes dans les données originales de X-COM 1. Recommandé pour une première installation (nécessite une connexion internet)."
LangString NAME_SecPortable ${LANG_FRENCH} "Installation Portable"
LangString DESC_SecPortable ${LANG_FRENCH} "Place tous les fichiers de ${GAME_NAME} dans le même répertoire, pour rendre l'installation portable (accessible de plusieurs endroits)."
LangString NAME_SecSteam ${LANG_FRENCH} "Lancer à partir de Steam"
LangString DESC_SecSteam ${LANG_FRENCH} "Remplace votre installation Steam X-COM 1 avec ${GAME_NAME}. La désinstallation restaurera la situation initiale."
LangString NAME_SecDesktop ${LANG_FRENCH} "Raccourcis Bureau"
LangString DESC_SecDesktop ${LANG_FRENCH} "Crée un raccourci sur le bureau ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_FRENCH} "Désinstaller X-COM"
LangString DESC_UnData ${LANG_FRENCH} "Effacer tous les fichiers de ${GAME_NAME}, ainsi que les mods et les ressources. Recommandé pour une réinstallation propre."
LangString NAME_UnUser ${LANG_FRENCH} "Effacer les données utilisateur"
LangString DESC_UnUser ${LANG_FRENCH} "Effacer toutes les données utilisateur de ${GAME_NAME}, y compris les sauvegardes, les impressions d'écran et les options. Recommandé pour une réinitialisation complète."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_FRENCH} "Répertoire de Données"
LangString LINK_Readme ${LANG_FRENCH} "Lisez-Moi"
LangString LINK_UserFolder ${LANG_FRENCH} "Répertoire Utilisateur"
LangString LINK_Uninstall ${LANG_FRENCH} "Désinstaller"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_FRENCH} "X-COM 1 ne se trouve pas dans ce dossier. ${GAME_NAME} nécessite une installation valide de X-COM pour fonctionner. Continuer?"
LangString WARN_XCUDetected ${LANG_FRENCH} "XcomUtil détecté. ${GAME_NAME} est incompatible avec XcomUtil et peut engendrer des instabilités. Continuer?"

;================SLOVAK================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_SLOVAK} "${GAME_NAME} vyžaduje kópiu hry UFO: Enemy Unknown / X-COM: UFO Defense. Tento krok môžete preskočiť pokiaľ aktualizujete existujúcu inštaláciu.$\n$\nSetup skopíruje vyžadované súbory do nasledujúcej zložky. Pre pokračovanie kliknite na ďalej."
LangString PAGE_UfoFolder_TITLE ${LANG_SLOVAK} "Vyberte umiestnenie X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_SLOVAK} "Vyberte zložku, v ktorej je nainštalovaný X-COM 1."
LangString DEST_UfoFolder ${LANG_SLOVAK} "Zložka s X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_SLOVAK} "Súbory hry"
LangString DESC_SecMain ${LANG_SLOVAK} "Súbory potrebné pre spustenie ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_SLOVAK} "Data Patch"
LangString DESC_SecPatch ${LANG_SLOVAK} "Opravuje chyby v dátach hry X-COM 1. Odporúča sa vybrať pri prvej inštalácii. (vyžaduje internetové spojenie)"
LangString NAME_SecDesktop ${LANG_SLOVAK} "Ikona na plochu"
LangString DESC_SecDesktop ${LANG_SLOVAK} "Vytvorí ikonu na ploche pre spustenie hry ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_SLOVAK} "Vymazať X-COM dáta"
LangString DESC_UnData ${LANG_SLOVAK} "Vymaže všetky dáta hry ${GAME_NAME}, vrátane modov a pôvodných súborov. Odporúča sa pre čistú reinštaláciu."
LangString NAME_UnUser ${LANG_SLOVAK} "Vymaž užívateľské dáta"
LangString DESC_UnUser ${LANG_SLOVAK} "Vymaže všetky užívateľské dáta hry ${GAME_NAME}, vrátane uložených pozícii, screenshotov a nastavení. Odporúča sa pre kompletné vymazanie."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_SLOVAK} "Zložka dát"
LangString LINK_Readme ${LANG_SLOVAK} "Readme"
LangString LINK_UserFolder ${LANG_SLOVAK} "Užívateľská zložka"
LangString LINK_Uninstall ${LANG_SLOVAK} "Odinštalovať"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_SLOVAK} "X-COM 1 sa nenašla v určenej zložke. ${GAME_NAME} vyžaduje platnú inštaláciu X-COMu, aby mohla fungovať. Pokračovať?"
LangString WARN_XCUDetected ${LANG_SLOVAK} "Bol detekovaný XcomUtil. ${GAME_NAME} je nekompatibilná s XComUtil a môže viesť k neštandardnému chovaniu hry. Pokračovať?"

;================CZECH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_CZECH} "${GAME_NAME} vyžaduje kopii hry UFO: Enemy Unknown / X-COM: UFO Defense. Tento krok můžete přeskočit pokud aktualizuje existující instalaci. Setup překopíruje požadované soubory do následujicí složky. Pro pokačování klikněte na další."
LangString PAGE_UfoFolder_TITLE ${LANG_CZECH} "Vyberte umístění X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_CZECH} "Vyberte složku, ve které je nainstalovaný X-COM 1."
LangString DEST_UfoFolder ${LANG_CZECH} "Složka s X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_CZECH} "Soubory hry"
LangString DESC_SecMain ${LANG_CZECH} "Soubory potřebné pro spuštění ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_CZECH} "Data Patch"
LangString DESC_SecPatch ${LANG_CZECH} "Opravuje chyby v datech hry X-COM 1. Doporučeno vybrat při první instalaci. (nutné internetové připojení)"
LangString NAME_SecDesktop ${LANG_CZECH} "Ikona na plochu"
LangString DESC_SecDesktop ${LANG_CZECH} "Vytvoří ikonu na ploše pro spouštění hry ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_CZECH} "Smazat X-COM data"
LangString DESC_UnData ${LANG_CZECH} "Smaže všechna data hry ${GAME_NAME}, včetně módů a původních souborů. Doporučeno pro čistou reinstalaci."
LangString NAME_UnUser ${LANG_CZECH} "Smaže uživatelská data"
LangString DESC_UnUser ${LANG_CZECH} "Smaže všechna uživatelská data hry ${GAME_NAME}, včetně uložených pozic, screenshotů a nastavení. Doporučeno pro kompletní smazání."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_CZECH} "Datová složka"
LangString LINK_Readme ${LANG_CZECH} "Readme"
LangString LINK_UserFolder ${LANG_CZECH} "Uživatelská složka"
LangString LINK_Uninstall ${LANG_CZECH} "Odinstalovat"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_CZECH} "X-COM 1 nebyl nalezen. ${GAME_NAME} vyžaduje platnou instalaci X-COM, aby mohl fungovat. Pokračovat?"
LangString WARN_XCUDetected ${LANG_CZECH} "Nalezeno XcomUtil. ${GAME_NAME} není kompatibilní s XcomUtil a může vést k nestandardnímu chování. Pokračovat?"

;================FINNISH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_FINNISH} "${GAME_NAME} edellyttää pelin UFO: Enemy Unknown / X-COM: UFO Defense alkuperäiskappaleen omistamista. Voit ohittaa tämän vaiheen, jos olet päivittämässä aiempaa asennusta.$\n$\nAsennus kopioi vaadittavat tiedostot seuraavasta kansiosta. Kopioidaksesi toisesta kansiosta napsauta Selaa ja valitse toinen kansio. Napsauta Seuraava jatkaaksesi."
LangString PAGE_UfoFolder_TITLE ${LANG_FINNISH} "Valitse X-COM 1:n sijainti"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_FINNISH} "Valitse kansio, johon X-COM 1 on asennettu."
LangString DEST_UfoFolder ${LANG_FINNISH} "X-COM 1:n kansio"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_FINNISH} "Pelin tiedostot"
LangString DESC_SecMain ${LANG_FINNISH} "Vaadittavat tiedostot ohjelman ${GAME_NAME} ajamiseksi."
LangString NAME_SecPatch ${LANG_FINNISH} "Datakorjauspäivitys"
LangString DESC_SecPatch ${LANG_FINNISH} "Korjaa virheitä X-COM 1:n datassa. Suositellaan ensiasennuksen yhteydessä. (Vaatii Internet-yhteyden)"
LangString NAME_SecDesktop ${LANG_FINNISH} "Työpöydän pikakuvake"
LangString DESC_SecDesktop ${LANG_FINNISH} "Luo työpöydälle pikakuvakkeen pelin ${GAME_NAME} pelaamiseksi."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_FINNISH} "Poista X-COM:n tiedot"
LangString DESC_UnData ${LANG_FINNISH} "Poistaa kaikki ohjelman ${GAME_NAME} tiedot, mukaan lukien modit ja X-COM-resurssit. Suositellaan puhtaan uudelleenasennuksen yhteydessä."
LangString NAME_UnUser ${LANG_FINNISH} "Poista käyttäjän tiedot"
LangString DESC_UnUser ${LANG_FINNISH} "Poistaa kaikki ohjelman ${GAME_NAME} käyttäjän tiedot, mukaan lukien tallennetut pelit, kuvakaappaukset ja asetukset. Suositellaan täydellisen poiston yhteydessä."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_FINNISH} "Datakansio"
LangString LINK_Readme ${LANG_FINNISH} "Lueminut"
LangString LINK_UserFolder ${LANG_FINNISH} "Käyttäjän kansio"
LangString LINK_Uninstall ${LANG_FINNISH} "Poista"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_FINNISH} "X-COM 1:stä ei löytynyt tästä kansiosta. ${GAME_NAME} vaatii kelvollisen asennuksen X-COM:sta toimiakseen. Jatketaanko?"
LangString WARN_XCUDetected ${LANG_FINNISH} "XcomUtil havaittu. ${GAME_NAME} ei ole yhteensopiva XcomUtilin kanssa, mikä saattaa aiheuttaa häiriöitä pelin toiminnassa. Jatketaanko?"

;================ITALIAN================

;--------------------------------
;Pages
   
LangString PAGE_UfoFolder ${LANG_ITALIAN} "${GAME_NAME} necessita di una copia di UFO: Enemy Unknown / X-COM: UFO Defense. Puoi saltare questo passaggio se stai aggiornando un’installazione precedente.$\n$\nSetup copierà i file richiesti dalla cartella seguente. Per copiare da un'altra cartella, clicca Esplora e scegli un’altra cartella. Clicca Continua per continuare."
LangString PAGE_UfoFolder_TITLE ${LANG_ITALIAN} "Scegli la cartella di X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_ITALIAN} "Scegli la cartella di installazione di X-COM 1"
LangString DEST_UfoFolder ${LANG_ITALIAN} "Cartella X-COM 1"

;--------------------------------
;Installer Sections
   
LangString NAME_SecMain ${LANG_ITALIAN} "File di gioco"
LangString DESC_SecMain ${LANG_ITALIAN} "File richiesti per far funzionare ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_ITALIAN} "Data Patch"
LangString DESC_SecPatch ${LANG_ITALIAN} "Aggiusta errori nei dati di X-COM 1. Raccomandato per la prima installazione. (richiede una connessione a internet)"
LangString NAME_SecDesktop ${LANG_ITALIAN} "Collegamento sul Desktop"
LangString DESC_SecDesktop ${LANG_ITALIAN} "Crea un collegamento sul Desktop per giocare a ${GAME_NAME}."
   
;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_ITALIAN} "Cancella i dati di X-COM 1"
LangString DESC_UnData ${LANG_ITALIAN} "Cancella tutti i dati di ${GAME_NAME}, incluse mods e risorse di gioco. Raccomandato per una reinstallazione pulita."
LangString NAME_UnUser ${LANG_ITALIAN} "Elimina i dati utente"
LangString DESC_UnUser ${LANG_ITALIAN} "Cancella tutti i dati utente di ${GAME_NAME}, inclusi salvataggi, screenshots e opzioni. Raccomandato per una pulizia completa."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_ITALIAN} "Cartella dati"
LangString LINK_Readme ${LANG_ITALIAN} "Readme"
LangString LINK_UserFolder ${LANG_ITALIAN} "Cartella utente"
LangString LINK_Uninstall ${LANG_ITALIAN} "Disinstalla"
   
;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_ITALIAN} "X-COM 1 non è stato trovato in questa cartella. ${GAME_NAME} richiede un’installazione valida di X-COM per funzionare. Continuare?"
LangString WARN_XCUDetected ${LANG_ITALIAN} "XcomUtil trovato. ${GAME_NAME} è incompatibile con XcomUtil e potrebbe subire malfunzionamenti vari. Continuare?"

;================UKRAINIAN================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_UKRAINIAN} "${GAME_NAME} потребує копію гри UFO: Enemy Unknown / X-COM: UFO Defense. Ви можете пропустити цей крок, якщо оновлюєте існуючу інсталяцію.$\n$\nВстанвлювач скопіює файли з наступної теки. Щоб копіювати з іншої теки, натисність Огляд і оберіть іншу теку. Натисніть Далі щоб продовжити."
LangString PAGE_UfoFolder_TITLE ${LANG_UKRAINIAN} "Оберіть розташування X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_UKRAINIAN} "Оберіть теку, в яку у Вас встановлений X-COM 1."
LangString DEST_UfoFolder ${LANG_UKRAINIAN} "Тека X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_UKRAINIAN} "Ігрові файли"
LangString DESC_SecMain ${LANG_UKRAINIAN} "Файли необхідні для запуску ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_UKRAINIAN} "Патч даних"
LangString DESC_SecPatch ${LANG_UKRAINIAN} "Виправляє помилки в даних з X-COM 1. Рекомендується при першій інсталяції. (вимагає з`єднання з Інтернетом)"
LangString NAME_SecDesktop ${LANG_UKRAINIAN} "Значок на стільниці"
LangString DESC_SecDesktop ${LANG_UKRAINIAN} "Створює на стільниці значок для запуску ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_UKRAINIAN} "Видалити дані X-COM"
LangString DESC_UnData ${LANG_UKRAINIAN} "Видаляє дані ${GAME_NAME}, включаючи моди та ресурси X-COM. Рекомендується для чистого перевстановлення."
LangString NAME_UnUser ${LANG_UKRAINIAN} "Видалити дані користувача"
LangString DESC_UnUser ${LANG_UKRAINIAN} "Видаляє всі дані користувача ${GAME_NAME}, включаючи збереження, знімки екрану і налаштування. Рекомендується для повного стирання гри."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_UKRAINIAN} "Тека даних"
LangString LINK_Readme ${LANG_UKRAINIAN} "ПрочитайМене"
LangString LINK_UserFolder ${LANG_UKRAINIAN} "Тека користувача"
LangString LINK_Uninstall ${LANG_UKRAINIAN} "Деінсталювати"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_UKRAINIAN} "X-COM 1 не було знайдено в цій теці. ${GAME_NAME} вимагає коректну інсталяцію гри X-COM для запуску. Продовжити?"
LangString WARN_XCUDetected ${LANG_UKRAINIAN} "Виявлено XcomUtil. ${GAME_NAME} несумісна з XcomUtil і може проявляти дивну поведінку. Продовжити?"

;================SPANISH================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_SPANISH} "${GAME_NAME} requiere una copia de UFO: Enemy Unknown / X-COM: UFO Defense. Este paso puede omitirse si es la actualización a una instalación previamente realizada.$\n$\nLa instalación copiará los archivos necesarios de la siguiente carpeta. Para elegir otra carpeta, haga click en Explorar y selecciónela. Haga click en Siguiente para continuar."
LangString PAGE_UfoFolder_TITLE ${LANG_SPANISH} "Elegir la ubicación de X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_SPANISH} "Elija la carpeta donde tiene instalada la copia de X-COM 1."
LangString DEST_UfoFolder ${LANG_SPANISH} "Carpeta de X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_SPANISH} "Archivos de Juegos"
LangString DESC_SecMain ${LANG_SPANISH} "Archivos requeridos para ejecutar ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_SPANISH} "Parchear los archivos originales"
LangString DESC_SecPatch ${LANG_SPANISH} "Soluciona diversos errores encontrados de los archivos de X-COM 1. Recomendable para una primera instalación. (Requere de tener acceso a internet)"
LangString NAME_SecPortable ${LANG_SPANISH} "Instalación Protable"
LangString DESC_SecPortable ${LANG_SPANISH} "Copia todo el contenido de ${GAME_NAME} en una misma carpeta, haciendo una instalación portable."
LangString NAME_SecSteam ${LANG_SPANISH} "Lanzar desde Steam"
LangString DESC_SecSteam ${LANG_SPANISH} "Reemplaza la instalación de Steam de X-COM 1 con ${GAME_NAME}. Al desinstalarlo, se restaura."
LangString NAME_SecDesktop ${LANG_SPANISH} "Acceso Directo al Escritorio"
LangString DESC_SecDesktop ${LANG_SPANISH} "Crea un acceso directo en el escritorio para jugar a ${GAME_NAME}."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_SPANISH} "Borrar los Archivos de X-COM"
LangString DESC_UnData ${LANG_SPANISH} "Borra todos los archivos de ${GAME_NAME}, incluyendo los mods y los recursos de X-COM. Recomendado para una reinstalación en limpio."
LangString NAME_UnUser ${LANG_SPANISH} "Borrar todos los Datos de Usuario"
LangString DESC_UnUser ${LANG_SPANISH} "Borra todos los archivos de usuario de ${GAME_NAME}, incluyendo partidas salvadas, capturas de imágen y las opciones. Se recomienda para no dejar rastro del juego."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_SPANISH} "Carpeta Data"
LangString LINK_Readme ${LANG_SPANISH} "Léame"
LangString LINK_UserFolder ${LANG_SPANISH} "Carpeta User"
LangString LINK_Uninstall ${LANG_SPANISH} "Desinstalar"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_SPANISH} "No se ha encontrado el juego X-COM 1 en esta carpeta. ${GAME_NAME} reqiere una instalación válida de X-COM para funcionar. ¿Desea continuar?"
LangString WARN_XCUDetected ${LANG_SPANISH} "Se ha detectado el programa XcomUtil. ${GAME_NAME} es incompatible con XcomUtil y puede ocasionar un comportamiento inesperado. ¿Desea continuar?"

;================PORTUGUESE================

;--------------------------------
;Pages

LangString PAGE_UfoFolder ${LANG_PORTUGUESE} "A aplicação ${GAME_NAME} requer uma cópia do jogo UFO: Enemy Unknown / X-COM: UFO Defense. Se estiver a atualizar uma instalação já existente pode seguir para o próximo passo.$\n$\nO assistente de instalação vai agora copiar os ficheiros necessários da seguinte pasta. Para selecionar uma pasta diferente, clique no botão 'Procurar'. Clique no botão 'Seguinte' para proceder."
LangString PAGE_UfoFolder_TITLE ${LANG_PORTUGUESE} "Selecionar localização do jogo X-COM 1"
LangString PAGE_UfoFolder_SUBTITLE ${LANG_PORTUGUESE} "Selecionar a pasta que contém uma instalação do jogo original X-COM 1"
LangString DEST_UfoFolder ${LANG_PORTUGUESE} "Localização do jogo X-COM 1"

;--------------------------------
;Installer Sections

LangString NAME_SecMain ${LANG_PORTUGUESE} "Ficheiros da aplicação"
LangString DESC_SecMain ${LANG_PORTUGUESE} "Ficheiros essenciais para executar a aplicação ${GAME_NAME}."
LangString NAME_SecPatch ${LANG_PORTUGUESE} "Atualizar X-COM 1"
LangString DESC_SecPatch ${LANG_PORTUGUESE} "Esta atualização corrige erros nos ficheiros do jogo original X-COM 1. Utilizar esta opção se estiver a instalar a aplicação pela primeira vez. (requer uma ligação à Internet)"
LangString NAME_SecDesktop ${LANG_PORTUGUESE} "Criar atalho"
LangString DESC_SecDesktop ${LANG_PORTUGUESE} "Criar atalho no ambiente de trabalho para executar o jogo."

;--------------------------------
;Uninstaller Descriptions

LangString NAME_UnData ${LANG_PORTUGUESE} "Apagar ficheiros originais X-COM"
LangString DESC_UnData ${LANG_PORTUGUESE} "Apagar todos os ficheiros relativos à aplicação ${GAME_NAME}, incluindo modificações e ficheiros do jogo original. Utilizar esta opção se desejar fazer uma reinstalação limpa do jogo."
LangString NAME_UnUser ${LANG_PORTUGUESE} "Apagar informações do utilizador"
LangString DESC_UnUser ${LANG_PORTUGUESE} "Apagar todos os ficheiros do utilizador relativos à aplicação ${GAME_NAME}, incluindo jogos guardados, capturas de ecrã e perfis de configuração. Utilizar esta opção para remover completamente a aplicação do sistema."

;--------------------------------
;Shortcuts

LangString LINK_DataFolder ${LANG_PORTUGUESE} "Pasta de ficheiros"
LangString LINK_Readme ${LANG_PORTUGUESE} "Leia-me"
LangString LINK_UserFolder ${LANG_PORTUGUESE} "Pasta de utilizador"
LangString LINK_Uninstall ${LANG_PORTUGUESE} "Remover"

;--------------------------------
;Warnings

LangString WARN_UFOMissing ${LANG_PORTUGUESE} "O jogo X-COM 1 não foi encontrado nesta pasta. A aplicação${GAME_NAME} requer uma instalação válida do jogo X-COM 1 para correr. Deseja proceder?"
LangString WARN_XCUDetected ${LANG_PORTUGUESE} "A expansão XcomUtil foi detetada neste instalação. A aplicação ${GAME_NAME} é incompatível com a expansão XcomUtil, o que pode dar origem a irregularidades. Deseja proceder?"
