/* 
 * OpenTyrian Classic: A modern cross-platform port of Tyrian
 * Copyright (C) 2007-2009  The OpenTyrian Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "opentyr.h"
#include "keyboard.h"
#include "palette.h"
#include "video.h"
#include "video_scale.h"

#include <assert.h>
#include <stdbool.h>

bool fullscreen_enabled = true;

SDL_Surface *display_surface;

SDL_Surface *VGAScreen, *VGAScreenSeg;
SDL_Surface *game_screen;
SDL_Surface *VGAScreen2;

void init_video( void )
{
	if (SDL_WasInit(SDL_INIT_VIDEO))
		return;
	
	if (SDL_InitSubSystem(SDL_INIT_VIDEO) == -1)
	{
		fprintf(stderr, "error: failed to initialize SDL video: %s\n", SDL_GetError());
		exit(1);
	}
	
	SDL_WM_SetCaption("OpenTyrian (ctrl-backspace to kill)", NULL);
	
#ifndef TARGET_GP2X
	VGAScreen = VGAScreenSeg = SDL_CreateRGBSurface(SDL_SWSURFACE, vga_width, vga_height, 8, 0, 0, 0, 0);
#endif /* TARGET_GP2X */
	
	reinit_video();
	
	SDL_FillRect(display_surface, NULL, 0x0);
	
	VGAScreen2 = SDL_CreateRGBSurface(SDL_SWSURFACE, vga_width, vga_height, 8, 0, 0, 0, 0);
	game_screen = SDL_CreateRGBSurface(SDL_SWSURFACE, vga_width, vga_height, 8, 0, 0, 0, 0);
	
	SDL_LockSurface(VGAScreen);
}

void reinit_video( void )
{
#ifdef TARGET_GP2X
	if (display_surface)
		return;
	
	scaler = 0;
#endif /* TARGET_GP2X */
	
	scale = 2;
	printf("SCALE %d\n", scale);
	int w = vga_width * scale,
	    h = vga_height * scale;
	int bpp = 16;
	int flags = SDL_SWSURFACE | SDL_HWPALETTE | (fullscreen_enabled ? SDL_FULLSCREEN : SDL_FULLSCREEN);
	
#ifndef TARGET_GP2X
	bpp = SDL_VideoModeOK(w, h, bpp, flags);
	if (bpp != 16)
		bpp = 16;
#else /* TARGET_GP2X */
	bpp = 16;
#endif /* TARGET_GP2X */
	
	display_surface = SDL_SetVideoMode(w, h, bpp, SDL_FULLSCREEN);
	
	if (display_surface == NULL)
	{
		fprintf(stderr, "error: failed to initialize SDL video: %s\n", SDL_GetError());
		exit(1);
	} else {
		printf("initialized SDL video: %dx%dx%d\n", w, h, bpp);
	}
	
#ifdef TARGET_GP2X
	VGAScreen = VGAScreenSeg = display_surface;
#endif /* TARGET_GP2X */
	
	input_grab();
	
	JE_showVGA();
}

void deinit_video( void )
{
	SDL_UnlockSurface(VGAScreen);
	
#ifndef TARGET_GP2X
	SDL_FreeSurface(VGAScreenSeg);
#endif /* TARGET_GP2X */
	SDL_FreeSurface(VGAScreen2);
	SDL_FreeSurface(game_screen);
	
	SDL_QuitSubSystem(SDL_INIT_VIDEO);


 	FILE *archivo2;
	char caracteres2[100];
	int c2;
 	archivo2 = fopen("/home/user/int_kb_layout","r");
	do { c2 = fscanf(archivo2, "%s", caracteres2); }
	while (c2 != EOF); 
	fclose(archivo2);
	if (caracteres2!="us") system("/usr/bin/gconftool-2 -s /apps/osso/inputmethod/int_kb_layout $(cat /home/user/int_kb_layout) -t string");


}

void JE_clr256( void )
{
	memset(VGAScreen->pixels, 0, VGAScreen->pitch * VGAScreen->h);
}

void JE_showVGA( void )
{
#ifndef TARGET_GP2X
			scalers[scaler].scaler16(VGAScreen, display_surface, scale);
#endif /* TARGET_GP2X */
	
	SDL_Flip(display_surface);
}

// kate: tab-width 4; vim: set noet:
