/* $Id: water_land.h 22991 2011-10-04 20:06:23Z rubidium $ */

/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file water_land.h Sprites to use and how to display them for water tiles (depots/locks). */

struct WaterDrawTileStruct {
	byte delta_x;
	byte delta_y;
	byte delta_z;
	byte size_x;
	byte size_y;
	byte size_z;
	SpriteID image;
};

#define BEGIN(image) { 0, 0, 0, 0, 0, 0, image }

/** Constructor macro for a terminating WaterDrawTileStruct entry in an array */
#define TILE_SEQ_END() { 0x80, 0, 0, 0, 0, 0, 0 }

static const WaterDrawTileStruct _shipdepot_display_seq_1[] = {
	BEGIN(0xFDD),
	{ 0, 15, 0, 16, 1, 0x14, 0xFE8 | (1 << PALETTE_MODIFIER_COLOUR) },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _shipdepot_display_seq_2[] = {
	BEGIN(0xFDD),
	{ 0,  0, 0, 16, 1, 0x14, 0xFEA },
	{ 0, 15, 0, 16, 1, 0x14, 0xFE6 | (1 << PALETTE_MODIFIER_COLOUR) },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _shipdepot_display_seq_3[] = {
	BEGIN(0xFDD),
	{ 15, 0, 0, 1, 0x10, 0x14, 0xFE9 | (1 << PALETTE_MODIFIER_COLOUR) },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _shipdepot_display_seq_4[] = {
	BEGIN(0xFDD),
	{  0, 0, 0, 1, 16, 0x14, 0xFEB },
	{ 15, 0, 0, 1, 16, 0x14, 0xFE7 | (1 << PALETTE_MODIFIER_COLOUR) },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct * const _shipdepot_display_seq[] = {
	_shipdepot_display_seq_1,
	_shipdepot_display_seq_2,
	_shipdepot_display_seq_3,
	_shipdepot_display_seq_4,
};

static const WaterDrawTileStruct _lock_display_seq_0[] = {
	BEGIN(1),
	{ 0,   0, 0, 0x10, 1, 0x14, 0 + 1 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 4 + 1 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_1[] = {
	BEGIN(0),
	{   0, 0, 0, 1, 0x10, 0x14, 0 },
	{ 0xF, 0, 0, 1, 0x10, 0x14, 4 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_2[] = {
	BEGIN(2),
	{ 0,   0, 0, 0x10, 1, 0x14, 0 + 2 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 4 + 2 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_3[] = {
	BEGIN(3),
	{   0, 0, 0, 1, 0x10, 0x14, 0 + 3 },
	{ 0xF, 0, 0, 1, 0x10, 0x14, 4 + 3 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_0b[] = {
	BEGIN(0xFDD),
	{ 0,   0, 0, 0x10, 1, 0x14, 8 + 1 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 12 + 1 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_1b[] = {
	BEGIN(0xFDD),
	{   0, 0, 0, 0x1, 0x10, 0x14, 8 },
	{ 0xF, 0, 0, 0x1, 0x10, 0x14, 12 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_2b[] = {
	BEGIN(0xFDD),
	{ 0,   0, 0, 0x10, 1, 0x14, 8 + 2 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 12 + 2 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_3b[] = {
	BEGIN(0xFDD),
	{   0, 0, 0, 1, 0x10, 0x14, 8 + 3 },
	{ 0xF, 0, 0, 1, 0x10, 0x14, 12 + 3 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_0t[] = {
	BEGIN(0xFDD),
	{ 0,   0, 0, 0x10, 1, 0x14, 16 + 1 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 20 + 1 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_1t[] = {
	BEGIN(0xFDD),
	{   0, 0, 0, 0x1, 0x10, 0x14, 16 },
	{ 0xF, 0, 0, 0x1, 0x10, 0x14, 20 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_2t[] = {
	BEGIN(0xFDD),
	{ 0,   0, 0, 0x10, 1, 0x14, 16 + 2 },
	{ 0, 0xF, 0, 0x10, 1, 0x14, 20 + 2 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct _lock_display_seq_3t[] = {
	BEGIN(0xFDD),
	{   0, 0, 0, 1, 0x10, 0x14, 16 + 3 },
	{ 0xF, 0, 0, 1, 0x10, 0x14, 20 + 3 },
	TILE_SEQ_END()
};

static const WaterDrawTileStruct * const _lock_display_seq[] = {
	_lock_display_seq_0,
	_lock_display_seq_1,
	_lock_display_seq_2,
	_lock_display_seq_3,

	_lock_display_seq_0b,
	_lock_display_seq_1b,
	_lock_display_seq_2b,
	_lock_display_seq_3b,

	_lock_display_seq_0t,
	_lock_display_seq_1t,
	_lock_display_seq_2t,
	_lock_display_seq_3t,
};

#undef BEGIN
#undef TILE_SEQ_END
