#!/usr/bin/env python
#coding:utf-8

# Download subtitles from opensubtitles.org (nautilus version)
# Default language is english, to change the language change sublanguageid parameter
# in the searchlist.append function

# Carlos Acedo (carlos@linux-labs.net)
# Inspired on subdownloader
# License GPL v2

# ported to maemo by int_ua (xintx.ua@gmail.com)
#TODO:
#open new dialogs until user cancels selection?
#open last directory at first
#multiple files selection - set_select_multiple
#i18n - os.environ('LC_MESSAGES')

import os
#from struct import *
from struct import calcsize,unpack
from sys import argv #
from xmlrpclib import ServerProxy, Error
from gtk import FileChooserDialog #
from commands import getoutput

class opensubtitle():
	def __init__(self):
		from dbus import SystemBus,Interface
		self.bus = SystemBus()
		self.dbus_object = self.bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		self.notification = Interface(self.dbus_object, 'org.freedesktop.Notifications')
		self.subslang='eng'

	def message(self,text,force=0):
		text = 'opensubtitles: '+str(text)
		try:
			if not(force): self.notification.SystemNoteInfoprint(text)
			if force: self.notification.SystemNoteDialog(text, 0, 'OK')
			#(notification.SystemNoteInfoprint,notification.SystemNoteDialog)[force](((text),(text, 0, 'OK'))[force])
		except:
			os.system('zenity --info --text="'+text+'"')
	def error(self,text):
		self.message("\nError:\n"+text,1)
	def main(self):
		pass
	def select(self,button=None):
		d = FileChooserDialog("Choose video file",None,action=0,buttons=("and Switch language",5,"or Search eng. subs",True))
		try: d.set_current_folder("/home/user/MyDocs/.videos")
		except: pass
		response=d.run()
		if response==5:
			self.subslang = getoutput('zenity --entry --text="Search subtitles with next language code: " --entry-text="eng" --title="?"')
			if self.subslang in (None,"",False):
				exit()
			response=True
		if response==True:
			filename=d.get_filename()
			d.destroy()
			return filename
		else:
			d.destroy()
			return False
	def hashFile(self,name):
		try:
			longlongformat = 'LL'  # signed long, unsigned long
			bytesize = calcsize(longlongformat)

			f = open(name, "rb")

			filesize = os.path.getsize(name)
			hash = filesize

			if filesize < 65536 * 2:
				self.message('File is too small.')
				return "SizeError"

			for x in range(65536/bytesize):
				buffer = f.read(bytesize)
				(l2, l1)= unpack(longlongformat, buffer)
				l_value = (long(l1) << 32) | long(l2)
				hash += l_value
				hash = hash & 0xFFFFFFFFFFFFFFFF #to remain as 64bit number


				f.seek(max(0,filesize-65536),0)
			for x in range(65536/bytesize):
				buffer = f.read(bytesize)
				(l2, l1) = unpack(longlongformat, buffer)
				l_value = (long(l1) << 32) | long(l2)
				hash += l_value
				hash = hash & 0xFFFFFFFFFFFFFFFF

			f.close()
			returnedhash =  "%016x" % hash
			return returnedhash

		except(IOError):
			self.error("Input/Output error while reading file hash")
			return "IOError"

# ================== Main program ========================
body = opensubtitle()
server = ServerProxy("http://api.opensubtitles.org/xml-rpc")
loginlang = "en"

try:
	peli = argv[1]
	if os.environ.__contains__('NAUTILUS_SCRIPT_SELECTED_FILE_PAHS'):
		peli = os.environ['NAUTILUS_SCRIPT_SELECTED_FILE_PATHS'].strip('\n')
except:
	peli=None
	peli = body.select()
if peli in (None,"",False):
	exit()

try:
	body.message("creating hash for a file")
	myhash = body.hashFile(peli)
	size = os.path.getsize(peli)
	body.message("Opening connection. Language="+body.subslang)
	session = server.LogIn("","",loginlang,"python")
	token = session["token"]
	searchlist = []
	searchlist.append({'sublanguageid':body.subslang,'moviehash':myhash,'moviebytesize':str(size)})
	body.message("searching on a server")
	moviesList = server.SearchSubtitles(token, searchlist)
	try:
#		print moviesList['data']
		kdialog_items = ''
		for item in moviesList['data']:
			kdialog_items = kdialog_items + '"' + item['SubFileName'] + '" '

		resp = os.popen('zenity --list --text="Select subtitle" --column="Subtitles" ' + kdialog_items).readline()
		if resp != '':
			index = 0
			subIndex = 0
			for item in moviesList['data']:
				if item['SubFileName'] == resp :
					subIndex = index
				else:
					index = index + 1

			subFileName = os.path.basename(peli)[:-3] + moviesList['data'][subIndex]['SubFileName'][-3:]
			subDirName = os.path.dirname(peli)
			subURL = moviesList['data'][subIndex]['SubDownloadLink']
			response = os.system('wget -O - ' + subURL + ' | gunzip  > "' + subDirName + '/' + subFileName + '"' )
			print 'wget -O - ' + subURL + ' | gunzip  > "' + subDirName + '/' + subFileName + '"'
			if response == 0:
				body.message("Subtitles " + subDirName + "/" + subFileName +" successfully saved.",1)
			else:
				body.error("An error ocurred downloading or writing the subtitle")

	except Exception,exc:
		body.message("No subtitles found.\n",1)
	except ProtocolError,pe:
		body.error("Protocol error. Maybe server is down for maintenance?\n"+str(pe))
	body.message("logging out of server")
	server.Logout(session["token"])
	body.message("logged out. Closing")
except Exception, v:
	print "Error: "+str(v)
	body.error(str(v))